package de.questmaster.wettkampf_funk_trainer.data;

import android.content.SharedPreferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AtFunkSprüche extends FunkSprüche {

    private String lastEinheit = "";
    private boolean lastEinheitGruppe;
    private boolean lastSchnellVerteiler;
    private boolean lastFahrzeugWasser;
    private boolean changedInLastUpdate = false;

    public AtFunkSprüche(SharedPreferences sp) {
        super(sp, FunkSpruch.Sprecher.A_TRUPP);
    }

    @Override
    public boolean isChangedInLastUpdate() {
        return super.isChangedInLastUpdate() || changedInLastUpdate;
    }

    private void checkForChanges(String currentEinheit, boolean currentEinheitGruppe, boolean currentSchnellVerteiler, boolean currentFahrzeugWasser) {
        // Defensive Null-Check für String-Parameter
        String safeCurrentEinheit = currentEinheit != null ? currentEinheit : "";

        changedInLastUpdate = !safeCurrentEinheit.equals(lastEinheit) || currentEinheitGruppe != lastEinheitGruppe ||
                currentSchnellVerteiler != lastSchnellVerteiler || currentFahrzeugWasser != lastFahrzeugWasser;
        lastEinheit = safeCurrentEinheit;
        lastEinheitGruppe = currentEinheitGruppe;
        lastSchnellVerteiler = currentSchnellVerteiler;
        lastFahrzeugWasser = currentFahrzeugWasser;
    }

    @Override
    List<FunkSpruch> initFunksprücheLoeschangriff(SharedPreferences sp) {
        String currentEinheit = sp.getString("einheit", "<Einheit fehlt>");
        boolean currentEinheitGruppe = sp.getBoolean("einheitGruppe", true);
        checkForChanges(currentEinheit, currentEinheitGruppe, lastSchnellVerteiler, lastFahrzeugWasser);

        List<FunkSpruch> sprueche;
        String einheittyp = "Staffelführer";
        if (currentEinheitGruppe) {
            einheittyp = "Gruppenführer";
        }
        String finalEinheittyp = einheittyp;

        sprueche = new ArrayList<FunkSpruch>() {{
            add(neu(FunkSpruch.Sprecher.KONTEXT, "Wiederholung Einsatz mit Bereitstellung..."));
            add(neu(FunkSpruch.Sprecher.A_TRUPP, "Zum Einsatz fertig!"));

            add(neu(FunkSpruch.Sprecher.KONTEXT, "Nach Ausrüsten am Verteiler..."));
            add(neu(FunkSpruch.Sprecher.A_TRUPP, "Angriffstrupp einsatzbereit!"));

            add(neu(FunkSpruch.Sprecher.KONTEXT, "Wiederholung des Einsatzbefehls..."));
            add(neu(FunkSpruch.Sprecher.A_TRUPP, "Zur Menschenrettung \nmit Pressluftatmern und 1. Rohr \nins Wohnzimmer \ndurch den Hauseingang \nvor!"));

            add(neu(FunkSpruch.Sprecher.KONTEXT, "Nach 1. Rohr in Stellung bringen..."));
            add(neu(FunkSpruch.Sprecher.A_TRUPP, "1. Rohr Wasser marsch!"));

            add(neu(FunkSpruch.Sprecher.KONTEXT, "Vor dem Betreten des Gebäudes..."));
            add(neu(FunkSpruch.Sprecher.A_TRUPP, currentEinheit + " " + finalEinheittyp + " von " + currentEinheit + " Angriffstrupp, kommen."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Hier " + currentEinheit + " " + finalEinheittyp + ", kommen."));
            add(neu(FunkSpruch.Sprecher.A_TRUPP, "Lungenautomat angeschlossen, betreten Gebäude, kommen."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Verstanden, kommen."));
            add(neu(FunkSpruch.Sprecher.A_TRUPP, "Ende."));

            add(neu(FunkSpruch.Sprecher.KONTEXT, "Beim Erreichen des Wohnzimmers..."));
            add(neu(FunkSpruch.Sprecher.A_TRUPP, currentEinheit + " " + finalEinheittyp + " von " + currentEinheit + " Angriffstrupp, kommen."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Hier " + currentEinheit + " " + finalEinheittyp + ", kommen."));
            add(neu(FunkSpruch.Sprecher.A_TRUPP, "Wohnzimmer erreicht, Person gefunden, Menschenrettung erst nach Brandbekämpfung möglich, Brandbekämpfung eingeleitet, kommen."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Verstanden, kommen."));
            add(neu(FunkSpruch.Sprecher.A_TRUPP, "Ende."));

            add(neu(FunkSpruch.Sprecher.KONTEXT, "Nach Ansprechen der Person..."));
            add(neu(FunkSpruch.Sprecher.A_TRUPP, currentEinheit + " " + finalEinheittyp + " von " + currentEinheit + " Angriffstrupp, kommen."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Hier " + currentEinheit + " " + finalEinheittyp + ", kommen."));
            add(neu(FunkSpruch.Sprecher.A_TRUPP, "Person bewusstlos, bringen sie ins Freie, kommen."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Verstanden, kommen."));
            add(neu(FunkSpruch.Sprecher.A_TRUPP, "Ende."));

            add(neu(FunkSpruch.Sprecher.KONTEXT, "Bei der Ablage auf Trage..."));
            add(neu(FunkSpruch.Sprecher.A_TRUPP, "Eine Person aus verrauchtem Bereich gerettet."));

            add(neu(FunkSpruch.Sprecher.KONTEXT, "Abschließende Meldung..."));
            add(neu(FunkSpruch.Sprecher.A_TRUPP, currentEinheit + " " + finalEinheittyp + " von " + currentEinheit + " Angriffstrupp, kommen."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Hier " + currentEinheit + " " + finalEinheittyp + ", kommen."));
            add(neu(FunkSpruch.Sprecher.A_TRUPP, "Eine Person aus dem Gebäude gerettet und dem Rettungsdienst übergeben, kommen."));
            add(neu(FunkSpruch.Sprecher.E_LEITER, "Verstanden, kommen."));
            add(neu(FunkSpruch.Sprecher.A_TRUPP, "Ende."));
        }};

        return sprueche;
    }

    @Override
    List<FunkSpruch> initFunksprücheGABC(SharedPreferences sp) {
        String currentEinheit = sp.getString("einheit", "<Einheit fehlt>");
        boolean currentEinheitGruppe = sp.getBoolean("einheitGruppe", true);
        boolean currentSchnellVerteiler = sp.getBoolean("schnellVerteiler", true);
        boolean currentFahrzeugWasser = sp.getBoolean("fahrzeugWasser", true);
        checkForChanges(currentEinheit, currentEinheitGruppe, currentSchnellVerteiler, currentFahrzeugWasser);

        List<FunkSpruch> sprueche;
        String einheittyp = "Staffelführer";
        if (currentEinheitGruppe) {
            einheittyp = "Gruppenführer";
        }
        String finalEinheittyp = einheittyp;

        sprueche = new ArrayList<FunkSpruch>() {
            {
                add(neu(FunkSpruch.Sprecher.KONTEXT, "Wiederholung Einsatz mit Bereitstellung..."));
                add(neu(FunkSpruch.Sprecher.A_TRUPP, "Zum Einsatz fertig!"));
            }
        };

        // Hier option schnellVerteiler
        List<FunkSpruch> funkSpruchList = Arrays.asList(
                neu(FunkSpruch.Sprecher.KONTEXT, "Nach Setzen des Schnellangriffsverteilers..."),
                neu(FunkSpruch.Sprecher.A_TRUPP, "Wasser marsch!")
        );
        if (currentSchnellVerteiler && currentFahrzeugWasser) {
            sprueche.addAll(funkSpruchList);
        }

        funkSpruchList = Arrays.asList(
                neu(FunkSpruch.Sprecher.KONTEXT, "Nach Markieren des Gefahrenbereichs und Ausrüstung..."),
                neu(FunkSpruch.Sprecher.A_TRUPP, "Angriffstrupp einsatzbereit!"),

                neu(FunkSpruch.Sprecher.KONTEXT, "Wiederholung des Einsatzbefehls..."),
                neu(FunkSpruch.Sprecher.A_TRUPP, "Zur Brandbekämpfung und Kühlung der Gasflasche \nmit Pressluftatmern und 1. Rohr \nzur brennenden Gefahrgutlache und Stapler \nüber den Hof \nvor!"),

                neu(FunkSpruch.Sprecher.KONTEXT, "Nach 1. Rohr in Stellung bringen..."),
                neu(FunkSpruch.Sprecher.A_TRUPP, "1. Rohr Wasser marsch!"),

                neu(FunkSpruch.Sprecher.KONTEXT, "Vor dem Betreten des Gefahrenbereichs..."),
                neu(FunkSpruch.Sprecher.A_TRUPP, "Lungenautomat angeschlossen, betreten Gefahrenbereich."),

                neu(FunkSpruch.Sprecher.KONTEXT, "Beim Einleiten der Brandbekämpfung..."),
                neu(FunkSpruch.Sprecher.A_TRUPP, currentEinheit + " " + finalEinheittyp + " von " + currentEinheit + " Angriffstrupp, kommen."),
                neu(FunkSpruch.Sprecher.E_LEITER, "Hier " + currentEinheit + " " + finalEinheittyp + ", kommen."),
                neu(FunkSpruch.Sprecher.A_TRUPP, "Einsatzziel erreicht, \nBrandbekämpfung aufgenommen, \nkommen."),
                neu(FunkSpruch.Sprecher.E_LEITER, "Verstanden, kommen."),
                neu(FunkSpruch.Sprecher.A_TRUPP, "Ende."),

                neu(FunkSpruch.Sprecher.KONTEXT, "Nach Übergabe der Person an Rettungsdienst..."),
                neu(FunkSpruch.Sprecher.A_TRUPP, currentEinheit + " " + finalEinheittyp + " von " + currentEinheit + " Angriffstrupp, kommen."),
                neu(FunkSpruch.Sprecher.E_LEITER, "Hier " + currentEinheit + " " + finalEinheittyp + ", kommen."),
                neu(FunkSpruch.Sprecher.A_TRUPP, "Feuer aus, \nGasflasche gekühlt, \nkommen."),
                neu(FunkSpruch.Sprecher.E_LEITER, "Verstanden, kommen."),
                neu(FunkSpruch.Sprecher.A_TRUPP, "Ende.")
        );
        sprueche.addAll(funkSpruchList);

        return sprueche;
    }

}
