// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Dutch Flemish (`nl`).
class AppLocalizationsNl extends AppLocalizations {
  AppLocalizationsNl([String locale = 'nl']) : super(locale);

  @override
  String get achievements => 'Prestaties';

  @override
  String get experimentalFeatures => 'Experimentele functies';

  @override
  String get looseWeight => 'Afvallen';

  @override
  String get gainWeight => 'Gain weight';

  @override
  String get looseWeightSubtitle => 'Schakelen tussen afvallen of aankomen.';

  @override
  String get days => 'Dagen';

  @override
  String get weeks => 'Weken';

  @override
  String get week => 'Week';

  @override
  String get months => 'Maanden';

  @override
  String get month => 'Maand';

  @override
  String get years => 'Jaren';

  @override
  String get year => 'Jaar';

  @override
  String get never => 'Nooit';

  @override
  String get weekly => 'Wekelijks';

  @override
  String get biweekly => 'Twee-wekelijks';

  @override
  String get monthly => 'Maandelijks';

  @override
  String get quarterly => 'Kwartaalijks';

  @override
  String get backupReminder => 'Maak regelmatig een back-up';

  @override
  String get backupReminderButton => 'back-up';

  @override
  String get backupSuccess => 'Back-up is succesvol geëxporteerd';

  @override
  String get backupInterval => 'Interval';

  @override
  String get lastBackup => 'Laatste back-up';

  @override
  String get nextBackup => 'Volgende Back-up';

  @override
  String get stats => 'Statistieken';

  @override
  String get trale => 'trale';

  @override
  String get unit => 'Eenheden';

  @override
  String get date => 'Datum';

  @override
  String get weight => 'Gewicht';

  @override
  String get user => 'Profiel';

  @override
  String get userSettings => 'Gebruiker Instellingen';

  @override
  String get dangerzone => 'Gevarenzone';

  @override
  String get settings => 'Instellingen';

  @override
  String get faq => 'Veelgestelde vragen';

  @override
  String get about => 'Informatie';

  @override
  String get defaultLang => 'Systeemstandaard';

  @override
  String get language => 'Taal';

  @override
  String get theme => 'Thema';

  @override
  String get translate => 'translate';

  @override
  String get translateSubtitle => 'Help translate the app';

  @override
  String get darkmode => 'Donker';

  @override
  String get lightmode => 'Licht';

  @override
  String get systemmode => 'Systeem';

  @override
  String get export => 'Exporteer alle metingen';

  @override
  String get exportSubtitle =>
      'Hierdoor worden alle metingen zichtbaar voor alle apps';

  @override
  String get exportDialog =>
      'Alle metingen zullen worden geëxporteerd naar het extern geheugen. Hiervoor zijn schrijfrechten nodig.';

  @override
  String get open => 'Openen';

  @override
  String get abort => 'Annuleren';

  @override
  String get import => 'Back-up importeren';

  @override
  String get importSubtitle => 'Metingen uit .txt Back-up bestand importeren';

  @override
  String get amoled => 'Zwart';

  @override
  String get amoledSubtitle => 'Achtergrond zwart voor donkere modus';

  @override
  String get reset => 'Reset applicatie';

  @override
  String get factoryReset => 'Fabrieksinstellingen herstellen';

  @override
  String get factoryResetSubtitle =>
      'Alle instellingen resetten en alle metingen verwijderen';

  @override
  String get factoryResetDialog =>
      'Weet je zeker dat je de standaardinstellingen wilt instellen? Hierdoor zullen alle instellingen en metingen verloren gaan en dit kan niet ongedaan gemaakt worden.';

  @override
  String get delete => 'Verwijderen';

  @override
  String get importingAbort => 'Importeren is geannuleerd';

  @override
  String get importDialog =>
      'Alle metingen aan huidige database toevoegen. Dit kan niet ongedaan worden gemaakt!';

  @override
  String get home => 'Startscherm';

  @override
  String get yes => 'Ja';

  @override
  String get ok => 'Oké';

  @override
  String get save => 'Opslaan';

  @override
  String get edit => 'Aanpassen';

  @override
  String get backup => 'Back-up';

  @override
  String get time => 'Tijd';

  @override
  String get assets => 'Middelen';

  @override
  String get packages => 'Pakketten';

  @override
  String get loading => 'Bezig met laden';

  @override
  String get measurements => 'Metingen';

  @override
  String get version => 'Versie';

  @override
  String get tpl => 'Licenties van derden';

  @override
  String get licence => 'Licentie';

  @override
  String get sourcecode => 'Broncode';

  @override
  String get openIssue => 'Probleem melden';

  @override
  String undertpl({
    required String years,
    required String author,
    required String licence,
  }) {
    return '© $years door $author onder $licence licentie';
  }

  @override
  String get addWeight => 'Voer je gewicht in';

  @override
  String get addHeight => 'Enter your height';

  @override
  String get height => 'height';

  @override
  String get target => 'target';

  @override
  String get interpolation => 'Tendens';

  @override
  String get personalization => 'personalization';

  @override
  String get strength => 'Sterkte';

  @override
  String get none => 'Geen';

  @override
  String get soft => 'Weinig';

  @override
  String get medium => 'Gemiddeld';

  @override
  String get strong => 'Sterk';

  @override
  String get welcome => 'Welkom';

  @override
  String get onBoarding1 =>
      'Deze eenvoudige applicatie helpt je om je droomgewicht te bereiken! Of je nu wilt aankomen, afvallen of gewoon op gewicht wilt blijven: betrouwbare gewichtsvoorspellingen en veelzijdige statistieken helpen je op koers te blijven en je doel te behalen!\n\nSluit je vandaag nog aan bij onze community en start met het bijhouden van je gewicht.\n🐺🤸‍♀️🏋‍♀️🧘‍♂️🏆🥇';

  @override
  String get onBoarding2 =>
      'Kies uit zes thema\'s om de app te personaliseren. Welke geeft het beste uitdrukking aan jouw gevoelens?';

  @override
  String get onBoarding3 =>
      'Bedankt voor je vertrouwen in onze app. 🙂\n\nAls je de app graag gebruikt, zijn we erg blij met je feedback, een bijdrage op Github of een kopje koffie. In ruil daarvoor besparen wij u vervelende en privacy schendende advertenties.';

  @override
  String get onBoarding2Title => 'Stijl';

  @override
  String get onBoarding3Title => 'Privacy';

  @override
  String get skip => 'Overslaan';

  @override
  String get startApp => 'Start';

  @override
  String get targetWeight => 'Doelgewicht';

  @override
  String get targetWeightMotivation =>
      'Het stellen van een streefgewicht is erg belangrijk en een stap in de goede richting. Het stellen van een doel helpt je om het doel daadwerkelijk te bereiken.';

  @override
  String get targetWeightShort => 'Doel';

  @override
  String get addUserName => 'Hoe kunnen we je noemen?';

  @override
  String get name => 'name';

  @override
  String get addTargetWeight => 'Doelgewicht toevoegen';

  @override
  String get intro1 => 'Druk hier';

  @override
  String get intro2 => 'om te starten';

  @override
  String get intro3 =>
      'Vandaag is een mooie dag om je eerste meting in te voeren!';

  @override
  String get faqtext =>
      'Hier vind je antwoorden op de meest gestelde vragen. Voel je vrij om zelf andere vragen te stellen op Github.';

  @override
  String get faq_q1 =>
      'Functie X ontbreekt. Wanneer wordt deze toegevoegd aan de app?';

  @override
  String get faq_a1 =>
      'Deze app wordt in onze vrije tijd onderhouden en wij proberen de app strak en simpel te houden. Wij zijn van mening dat het toevoegen van teveel functies de app minder bruikbaar maakt. Als u denkt dat we een belangrijke functie missen, kunt u gerust een aanvraag of een samenvoegverzoek openen.';

  @override
  String get faq_q2 => 'Kan ik het intro scherm opnieuw bekijken?';

  @override
  String get faq_a2 => 'Jazeker! Druk maar op de knop hieronder.';

  @override
  String get faq_a2_widget => 'Intro opnieuw bekijken';

  @override
  String get faq_q3 => 'Wat betekend de app icoon?';

  @override
  String get faq_a3 =>
      'Een zittende huilende wolf met zijn staart gedeeltelijk verborgen door de letter \'t\' en de letter \'r\'.';

  @override
  String get faq_q4 =>
      'Can I enter a target weight below 50kg / 110 lb / 7.9 st?';

  @override
  String get faq_a4 =>
      'Yes, by providing your height.\n\nAnorexia is a serious disease that is increasingly becoming a problem for society as a whole, partly due to the many negative examples on social media. To support prevention efforts, we do not allow target weights below 50 kg / 110 lb / 7.9 st. Entering your height allows us to calculate a minimum target weight corresponding to a BMI of 18.5.';

  @override
  String get target_weight_warning =>
      'Anorexia is een ernstige ziekte die, mede door de vele negatieve voorbeelden op sociale media, steeds meer een probleem wordt voor de samenleving als geheel. Als onderdeel van onze bijdrage aan preventie is een streefgewicht lager dan 50 Kg / 110 lb / 7,9 st niet mogelijk.';

  @override
  String get max => 'Max';

  @override
  String get min => 'Min';

  @override
  String get change => 'Verschil';

  @override
  String get totalChange => 'Totaal verschil';

  @override
  String get schemeVariant => 'Scheme variant';

  @override
  String get schemeVariantDescription =>
      'Choose a variant to determine how the color scheme is created from the selected seed color.';

  @override
  String get themeDescription =>
      'Choose a seed color to determine the color scheme.';

  @override
  String get additionalSettings => 'additional settings';

  @override
  String get mean => 'Gemiddeld';

  @override
  String get measurementFrequency => 'Meetfrequentie';

  @override
  String get targetWeightReached => 'Je hebt je streefgewicht behaald!';

  @override
  String get targetWeightReachedIn => 'over om je streefgewicht te halen';

  @override
  String get maxStreak => 'Langste reeks';

  @override
  String get currentStreak => 'Huidige reeks';

  @override
  String get timeSinceFirstMeasurement => 'Tijd sinds eerste meting';

  @override
  String get firstDay => 'Eerste dag van de week';

  @override
  String get highContrast => 'High contrast';

  @override
  String get bmi => 'BMI';

  @override
  String get back => 'back';

  @override
  String get userDialogTitle => 'User settings';

  @override
  String get importLongDescription =>
      'You can import data. This will not delete your existing data and any duplicate entries will be ignored. \'txt\' files from trale and \'csv\' files from OpenScales are supported. In \'csv\' files, the columns must be named \'weight\' and \'datetime\'; otherwise, the first column will be parsed as a date and the second as a weight. If you are using a custom \'txt\' file, it should have one of the following formats:';

  @override
  String get donation => 'Donation';

  @override
  String get donationSubtitle => 'Support the development of trale';

  @override
  String get customization => 'Customization';

  @override
  String get personalizationTitle => 'Personalization';

  @override
  String get personalizationSubtitle => 'Customize your experience';

  @override
  String get themeSubtitle => 'Set the color scheme';

  @override
  String get languageSubtitle => 'Set the language';

  @override
  String get dataSettings => 'Data settings';

  @override
  String get importAndExport => 'Import and export';

  @override
  String get importAndExportSubtitle => 'Save and load your data';

  @override
  String get aboutTheApp => 'About the app';

  @override
  String get faqSubtitle => 'Find answers to common questions';

  @override
  String get aboutSubtitle => 'Version and license information';

  @override
  String interpolationExplanation({required String noneInterpol}) {
    return 'Interpolation uses state-of-the-art Gaussian filtering to smooth your weight curve and create a clearer trend. Higher strength levels reduce daily fluctuations but may hide short-term changes. Choose \'$noneInterpol\' to see your raw measurements, though extrapolation will still use soft smoothing.';
  }

  @override
  String get unitTitle => 'Unit';

  @override
  String get dateSettings => 'Date settings';

  @override
  String get format => 'Format';

  @override
  String get defaultFormat => 'Default';

  @override
  String get openIssueSubtitle => 'Help improve the app by providing feedback.';

  @override
  String get aboutDescription1 =>
      'A simple weight log with short-term extrapolation.';

  @override
  String get aboutDescription2 =>
      'Your privacy is respected. No revenue sources in the app, nor error logs sent. Please open an issue if you have problems.';

  @override
  String get aboutDescription3 =>
      'Made by two devs with little spare time. Consider contributing or donating.';

  @override
  String get measurementDeleted => 'Measurement was deleted.';

  @override
  String get undo => 'Undo';

  @override
  String get measurementHintTitle => 'Edit measurements';

  @override
  String get measurementHintSubtitle =>
      'Long press on a measurement to edit or delete it. Swipe this message to dismiss.';
}
