// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for French (`fr`).
class AppLocalizationsFr extends AppLocalizations {
  AppLocalizationsFr([String locale = 'fr']) : super(locale);

  @override
  String get achievements => 'Succès';

  @override
  String get experimentalFeatures => 'fonctionnalités expérimentales';

  @override
  String get looseWeight => 'Perdre du poids';

  @override
  String get gainWeight => 'Gagner du poids';

  @override
  String get looseWeightSubtitle =>
      'Changer entre perdre du poids ou gagner du poids.';

  @override
  String get days => 'jours';

  @override
  String get weeks => 'semaines';

  @override
  String get week => 'semaine';

  @override
  String get months => 'mois';

  @override
  String get month => 'mois';

  @override
  String get years => 'années';

  @override
  String get year => 'année';

  @override
  String get never => 'jamais';

  @override
  String get weekly => 'hebdomadairement';

  @override
  String get biweekly => 'bihebdomadairement';

  @override
  String get monthly => 'mensuellement';

  @override
  String get quarterly => 'trimestriellement';

  @override
  String get backupReminder => 'Sauvegardez régulièrement';

  @override
  String get backupReminderButton => 'sauvegarder';

  @override
  String get backupSuccess => 'Sauvegarde exportée avec succès';

  @override
  String get backupInterval => 'Fréquence';

  @override
  String get lastBackup => 'dernière sauvegarde';

  @override
  String get nextBackup => 'prochaine sauvegarde';

  @override
  String get stats => 'Statistiques';

  @override
  String get trale => 'trale';

  @override
  String get unit => 'Unités';

  @override
  String get date => 'Date';

  @override
  String get weight => 'Poids';

  @override
  String get user => 'Profil utilisateur';

  @override
  String get userSettings => 'Paramètres utilisateur';

  @override
  String get dangerzone => 'Zone dangereuse';

  @override
  String get settings => 'Paramètres';

  @override
  String get faq => 'FAQ';

  @override
  String get about => 'À propos';

  @override
  String get defaultLang => 'Par défaut (système)';

  @override
  String get language => 'Langue';

  @override
  String get theme => 'Thème';

  @override
  String get translate => 'translate';

  @override
  String get translateSubtitle => 'Help translate the app';

  @override
  String get darkmode => 'Sombre';

  @override
  String get lightmode => 'Lumineux';

  @override
  String get systemmode => 'Système';

  @override
  String get export => 'Exporter l\'intégralité des mesures';

  @override
  String get exportSubtitle =>
      'Partager toutes les mesures vers n\'importe quelle application.';

  @override
  String get exportDialog =>
      'Ceci exporte toutes les mesures vers le stockage externe. Nécessite les permissions en écriture.';

  @override
  String get open => 'Ouvrir';

  @override
  String get abort => 'Annuler';

  @override
  String get import => 'Importer une sauvegarde';

  @override
  String get importSubtitle =>
      'Importer des mesures depuis une sauvegarde au format .txt.';

  @override
  String get amoled => 'Noir';

  @override
  String get amoledSubtitle =>
      'En mode sombre, utiliser du noir pur en tant que couleur d\'arrière-plan.';

  @override
  String get reset => 'Réinitialiser l\'application';

  @override
  String get factoryReset => 'Réinitialisation aux paramètres d\'usine';

  @override
  String get factoryResetSubtitle =>
      'Réinitialiser tous les paramètres et supprimer toutes les mesures.';

  @override
  String get factoryResetDialog =>
      'Réinitialiser complètement l\'application ? Cela va supprimer tous vos réglages ainsi que toutes les mesures que vous auriez pu ajouter. Cette opération est irréversible.';

  @override
  String get delete => 'Supprimer';

  @override
  String get importingAbort => 'Importation annulée.';

  @override
  String get importDialog =>
      'Ajouter toutes les mesures dans la base de données actuelle. Cette opération est irréversible !';

  @override
  String get home => 'Accueil';

  @override
  String get yes => 'Oui';

  @override
  String get ok => 'OK';

  @override
  String get save => 'Enregistrer';

  @override
  String get edit => 'Modifier';

  @override
  String get backup => 'Sauvegarde';

  @override
  String get time => 'Horaire';

  @override
  String get assets => 'ressources';

  @override
  String get packages => 'packages';

  @override
  String get loading => 'Chargement';

  @override
  String get measurements => 'Mesures';

  @override
  String get version => 'Version';

  @override
  String get tpl => 'Licences tierces';

  @override
  String get licence => 'Licence';

  @override
  String get sourcecode => 'Code source';

  @override
  String get openIssue => 'Ouvrir une issue';

  @override
  String undertpl({
    required String years,
    required String author,
    required String licence,
  }) {
    return '© $years par $author sous licence $licence';
  }

  @override
  String get addWeight => 'Entrez votre poids';

  @override
  String get addHeight => 'Entrez votre taille';

  @override
  String get height => 'height';

  @override
  String get target => 'target';

  @override
  String get interpolation => 'interpolation';

  @override
  String get personalization => 'personalization';

  @override
  String get strength => 'force';

  @override
  String get none => 'Aucune';

  @override
  String get soft => 'Légère';

  @override
  String get medium => 'Moyenne';

  @override
  String get strong => 'Forte';

  @override
  String get welcome => 'Bienvenue';

  @override
  String get onBoarding1 =>
      'Cette application épurée conçue en design Material-You vous aide à atteindre votre poids de rêve ! Que vous souhaitiez prendre du poids, en perdre, ou simplement conserver votre poids actuel : des prévisions de poids fiables et des statistiques élaborées vous aident à tenir vos objectifs.\n\nRejoignez dès aujourd\'hui aujourd\'hui notre communauté afin de vous tracer vous-même.\n🐺🤸‍♀️🏋‍♀️🧘‍♂️🏆🥇';

  @override
  String get onBoarding2 =>
      'Choisissez l\'un des six thèmes pour personnaliser l\'application. Lequel reflète le mieux votre état d\'esprit ?';

  @override
  String get onBoarding3 =>
      'Merci à vous d\'essayer notre application. 🙂\n\nSi vous l\'appréciez, nous serions ravis d\'avoir vos retours, une contribution sur GitHub ou un café. En retour, on vous épargne les publicités embêtantes et intrusives pour votre vie privée.';

  @override
  String get onBoarding2Title => 'Style';

  @override
  String get onBoarding3Title => 'Vie privée';

  @override
  String get skip => 'Passer';

  @override
  String get startApp => 'Démarrer';

  @override
  String get targetWeight => 'Objectif de poids';

  @override
  String get targetWeightMotivation =>
      'Définir un objectif de poids est très important, et c\'est un premier pas dans la bonne direction. Avoir un objectif clairement en tête vous motive à faire plus pour l\'atteindre.';

  @override
  String get targetWeightShort => 'Objectif';

  @override
  String get addUserName => 'Comment devons-nous vous appeler ?';

  @override
  String get name => 'name';

  @override
  String get addTargetWeight => 'Ajoutez votre objectif de poids';

  @override
  String get intro1 => 'Appuyez';

  @override
  String get intro2 => 'pour commencer';

  @override
  String get intro3 =>
      'C\'est une belle journée pour ajouter votre première mesure de poids !';

  @override
  String get faqtext =>
      'Vous trouverez ici des réponses aux questions les plus fréquemment posées. Si vous n\'y trouvez pas la réponse souhaitée, n\'hésitez pas à ouvrir une issue dans le projet GitHub.';

  @override
  String get faq_q1 =>
      'Il manque la fonctionnalité X. Quand avez-vous prévu de l\'implémenter ?';

  @override
  String get faq_a1 =>
      'L\'application est développée pendant notre temps libre, et nous essayons de la garder simple et efficace. Ajouter trop de fonctionnalités la rendrait selon nous moins pratique. Si vous pensez néanmoins que nous oublions une fonctionnalité importante, n\'hésitez pas à ouvrir une issue ou à nous soumettre une merge request.';

  @override
  String get faq_q2 =>
      'Puis-je voir à nouveau l\'écran de bienvenue/présentation ?';

  @override
  String get faq_a2 => 'Bien sûr ! Appuyez simplement sur l\'icône ci-dessous.';

  @override
  String get faq_a2_widget => 'Revenir à l\'écran de présentation';

  @override
  String get faq_q3 => 'Que représente l\'icône de l\'application ?';

  @override
  String get faq_a3 =>
      'Un loup assis qui hurle, sa queue étant partiellement cachée par les lettres « t » et « r ».';

  @override
  String get faq_q4 =>
      'Puis-je renseigner un poids inférieur à 50kg / 110 lb / 7,9 st ?';

  @override
  String get faq_a4 =>
      'Oui, en renseignant votre taille.\n\nL\'anorexie est une maladie grave qui est en train de devenir un problème d\'ensemble pour la société, en partie à cause des mauvais exemples sur les réseaux sociaux. C\'est pourquoi, à des fins de prévention, nous n\'autorisons pas de poids cible inférieur à 50 kg / 110 lb / 7,9 st. Renseigner votre taille nous permets de calculer un poids cible minimal correspondant à un IMC de 18,5.';

  @override
  String get target_weight_warning =>
      'L\'anorexie est une maladie grave qui devient un problème de société de plus en plus grave, en partie à cause des mauvais exemples présents sur les réseaux sociaux. Afin de faire notre part de prévention sur ce sujet, il est impossible de définir un objectif de poids inférieur à 50kg / 110 lb / 7.9 st.';

  @override
  String get max => 'max';

  @override
  String get min => 'min';

  @override
  String get change => 'évolution';

  @override
  String get totalChange => 'évolution totale';

  @override
  String get schemeVariant => 'variante de palette';

  @override
  String get schemeVariantDescription =>
      'Choose a variant to determine how the color scheme is created from the selected seed color.';

  @override
  String get themeDescription =>
      'Choose a seed color to determine the color scheme.';

  @override
  String get additionalSettings => 'additional settings';

  @override
  String get mean => 'moyenne';

  @override
  String get measurementFrequency => 'fréquence de mesure';

  @override
  String get targetWeightReached => 'vous avez atteint votre poids cible !';

  @override
  String get targetWeightReachedIn =>
      'restant(e)s pour atteindre le poids cible';

  @override
  String get maxStreak => 'plus longue série';

  @override
  String get currentStreak => 'série actuelle';

  @override
  String get timeSinceFirstMeasurement => 'temps depuis la première mesure';

  @override
  String get firstDay => 'Premier jour';

  @override
  String get highContrast => 'Contraste élevé';

  @override
  String get bmi => 'IMC';

  @override
  String get back => 'back';

  @override
  String get userDialogTitle => 'User settings';

  @override
  String get importLongDescription =>
      'You can import data. This will not delete your existing data and any duplicate entries will be ignored. \'txt\' files from trale and \'csv\' files from OpenScales are supported. In \'csv\' files, the columns must be named \'weight\' and \'datetime\'; otherwise, the first column will be parsed as a date and the second as a weight. If you are using a custom \'txt\' file, it should have one of the following formats:';

  @override
  String get donation => 'Donation';

  @override
  String get donationSubtitle => 'Support the development of trale';

  @override
  String get customization => 'Customization';

  @override
  String get personalizationTitle => 'Personalization';

  @override
  String get personalizationSubtitle => 'Customize your experience';

  @override
  String get themeSubtitle => 'Set the color scheme';

  @override
  String get languageSubtitle => 'Set the language';

  @override
  String get dataSettings => 'Data settings';

  @override
  String get importAndExport => 'Import and export';

  @override
  String get importAndExportSubtitle => 'Save and load your data';

  @override
  String get aboutTheApp => 'About the app';

  @override
  String get faqSubtitle => 'Find answers to common questions';

  @override
  String get aboutSubtitle => 'Version and license information';

  @override
  String interpolationExplanation({required String noneInterpol}) {
    return 'Interpolation uses state-of-the-art Gaussian filtering to smooth your weight curve and create a clearer trend. Higher strength levels reduce daily fluctuations but may hide short-term changes. Choose \'$noneInterpol\' to see your raw measurements, though extrapolation will still use soft smoothing.';
  }

  @override
  String get unitTitle => 'Unit';

  @override
  String get dateSettings => 'Date settings';

  @override
  String get format => 'Format';

  @override
  String get defaultFormat => 'Default';

  @override
  String get openIssueSubtitle => 'Help improve the app by providing feedback.';

  @override
  String get aboutDescription1 =>
      'A simple weight log with short-term extrapolation.';

  @override
  String get aboutDescription2 =>
      'Your privacy is respected. No revenue sources in the app, nor error logs sent. Please open an issue if you have problems.';

  @override
  String get aboutDescription3 =>
      'Made by two devs with little spare time. Consider contributing or donating.';

  @override
  String get measurementDeleted => 'Measurement was deleted.';

  @override
  String get undo => 'Undo';

  @override
  String get measurementHintTitle => 'Edit measurements';

  @override
  String get measurementHintSubtitle =>
      'Long press on a measurement to edit or delete it. Swipe this message to dismiss.';
}
