# FileSaver
[![Discord](https://www.hassanansari.dev/public/file_saver_discord.png)](https://discord.gg/4yRFt68kty)


## Huge Shoutout to all the contributors and the people who are using this package, I'm really grateful to all of you. Thank you for your support.

This plugin package primarily focuses on one task: saving files on Android, iOS, Web, Windows, MacOS, and Linux. 
It might not have a plethora of features, but it does this job well.
This package depends on path_provider for Android and iOS and basic html anchor for Web. The main reason I built this plugin was to
avoid using HTML just for downloading files. The plugin is pretty simple and saves the file in Downloads folder in
Windows, MacOS, Linux and directly downloads the file in Web, in iOS, the file is Saved in Application
Documents Directory, and in Android it is saved in the applications files directory Android/data/your.package.name/file/your_file.extension.

## Getting Started

The plugin itself is pretty easy to use. Just call the method saveFile() with respective arguments.

```dart
await FileSaver.instance.saveFile({
      required String name,
      Uint8List? bytes,
      File? file,
      String? filePath,
      LinkDetails? link,
      String fileExtension = "",
      bool includeExtension = true,
      MimeType mimeType = MimeType.other,
      String? customMimeType,
      Dio? dioClient,
      Uint8List Function(Uint8List)? transformDioResponse,
});
```

This saveFile() method has 9 Named arguments.

_String name_ which takes the name of the file,\
_Uint8List bytes_ which will be your actual encoded file,\
Or\
_File file_ which will be your file in the File object (from dart:io)\
Or\
_Stirng filePath_ which will be your file path\
Or\
_LinkDetails link_ which will provide the link, header, request methid and body to your file. LinkDetails can be used as 
```dart
LinkDetails(
      link: "https://www.example.com/file.extentions",
      headers: {"your-header-key": "you-header-value"},
      method: "POST",
      body: body
)
```
\
Out of these parameters, you will have to use atleast one

_String fileExtension_ this will be your file extension.\
_bool includeExtension_ this controls whether to include the extension in the saved file name. Set to false to save files without extension (e.g., "myfile" instead of "myfile.txt"). Defaults to true.\
Another parameter is _MimeType type_ Specifically for Web, which will be your file
type

_String customMimeType_ this will be your custom mime type, if you want to use your own mime type, you can use this parameter

_Dio dioClient_ this will be your dio client, if you want to use dio for downloading the file, you can use this parameter

_Uint8List Function(Uint8List) transformDioResponse_ this will be your function to transform the response, if you want to transform the response as per your requirement, you can use this parameter

MimeType is also included in my Package, I've included types for **Sheets, Presentation, Word, Plain Text, PDF,
MP3, MP4 and many other common formats**

or you can call saveAs() _only available for android, iOS, macOS & windows at the moment_

```dart
await FileSaver.instance.saveAs({
      required String name,
      Uint8List? bytes,
      File? file,
      String? filePath,
      LinkDetails? link,
      required String fileExtension,
      bool includeExtension = true,
      required MimeType mimeType,
      String? customMimeType,
      Dio? dioClient,
      Uint8List Function(Uint8List)? transformDioResponse,
});
```

All the parameters in this method is same as the saveFile() method.

### Note: customMimeType can only be used when mimeType is set to MimeType.custom

### Usage Examples:

**Save file with extension (default behavior):**
```dart
await FileSaver.instance.saveFile(
  name: "my_document",
  bytes: fileBytes,
  fileExtension: "pdf",
  mimeType: MimeType.pdf,
);
// Saves as: my_document.pdf
```

**Save file without extension:**
```dart
await FileSaver.instance.saveFile(
  name: "my_document",
  bytes: fileBytes,
  fileExtension: "pdf",
  includeExtension: false,
  mimeType: MimeType.pdf,
);
// Saves as: my_document
```

**Save file from URL without extension:**
```dart
await FileSaver.instance.saveFile(
  name: "downloaded_file",
  link: LinkDetails(link: "https://example.com/file.pdf"),
  fileExtension: "pdf",
  includeExtension: false,
  mimeType: MimeType.pdf,
);
// Saves as: downloaded_file
```

### Storage Permissions & Network Permissions:

> ##### _These Settings are optional for iOS, as in iOS the file will be saved in application documents directory but will not be visible in Files application, to make your file visible in iOS Files application, make the changes mentioned below._

#### iOS:

Go to your project folder, ios/Runner/info.plist and Add these keys:

```xml
<key>LSSupportsOpeningDocumentsInPlace</key>
<true/>
<key>UIFileSharingEnabled</key>
<true/>
```

![iOS](https://raw.githubusercontent.com/incrediblezayed/file_saver/main/images/ios.png)

#### Or in XCode:

Open Your Project in XCode (Open XCode -> Open a project or file -> Your_Project_Folder/ios/Runner.xcworkspace)
Open info.plist Add these rows:

Application supports iTunes file sharing (Boolean -> Yes)

Supports opening documents in place (Boolean -> Yes)

![iOS Xcode](https://raw.githubusercontent.com/incrediblezayed/file_saver/main/images/iOSXcode.png)

#### macOS:

Go to your project folder, macOS/Runner/DebugProfile.entitlements

> For release you need to open 'YOUR_PROJECT_NAME'Profile.entitlements

and add the following key:

```xml
<key>com.apple.security.files.downloads.read-write</key>
<true/>
```

![MacOS](https://raw.githubusercontent.com/incrediblezayed/file_saver/main/images/macos.png)

#### Or in XCode:

Open Your Project in XCode (Open XCode -> Open a project or file -> Your_Project_Folder/macos/Runner.xcworkspace)
Open your entitlement file (DebugProfile.entitlements & 'YOUR_PROJECT_NAME'Profile.entitlements)

Add these rows:
![MacOS Xcode](https://raw.githubusercontent.com/incrediblezayed/file_saver/main/images/macOSXcode.png)

and if you get Client Socket Exception while saving files in MacOS from link,
you have to add this key in the DebugProfile.entitlements and Release.entitlements of your macOS application and set the value to true

```xml
<key>com.apple.security.network.client</key>
<true/>
```

*You can find these files in the project_folder/macos/Runner/ directory.*

#### And You're done

## Thank You For Reading this far :)
