// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Chinese (`zh`).
class AppLocalizationsZh extends AppLocalizations {
  AppLocalizationsZh([String locale = 'zh']) : super(locale);

  @override
  String get achievements => '统计分析';

  @override
  String get experimentalFeatures => '实验功能';

  @override
  String get looseWeight => '减肥模式';

  @override
  String get gainWeight => '增重模式';

  @override
  String get looseWeightSubtitle => '在减肥模式和增重模式之间切换。';

  @override
  String get days => '天';

  @override
  String get weeks => '周';

  @override
  String get week => '周';

  @override
  String get months => '个月';

  @override
  String get month => '月';

  @override
  String get years => '年';

  @override
  String get year => '年';

  @override
  String get never => '不自动备份';

  @override
  String get weekly => '每周备份';

  @override
  String get biweekly => '每两周备份';

  @override
  String get monthly => '每月备份';

  @override
  String get quarterly => '每季度备份';

  @override
  String get backupReminder => '请记得定期备份你的数据';

  @override
  String get backupReminderButton => '备份';

  @override
  String get backupSuccess => '备份已成功导出';

  @override
  String get backupInterval => '自动备份';

  @override
  String get lastBackup => '上次备份时间';

  @override
  String get nextBackup => '下次备份时间';

  @override
  String get stats => '统计';

  @override
  String get trale => 'Trale';

  @override
  String get unit => '数据单位';

  @override
  String get date => '日期';

  @override
  String get weight => '重量';

  @override
  String get user => '用户资料';

  @override
  String get userSettings => '用户设置';

  @override
  String get dangerzone => '风险选项';

  @override
  String get settings => '设置';

  @override
  String get faq => '常见问题';

  @override
  String get about => '关于';

  @override
  String get defaultLang => '系统默认';

  @override
  String get language => '语言';

  @override
  String get theme => '主题';

  @override
  String get translate => 'translate';

  @override
  String get translateSubtitle => 'Help translate the app';

  @override
  String get darkmode => '暗色模式';

  @override
  String get lightmode => '亮色模式';

  @override
  String get systemmode => '跟随系统';

  @override
  String get export => '备份数据';

  @override
  String get exportSubtitle => '导出所有测量数据。';

  @override
  String get exportDialog => '这将把所有测量数据导出到外部存储设备，此操作需要您授予存储权限。';

  @override
  String get open => '打开';

  @override
  String get abort => '取消';

  @override
  String get import => '恢复数据';

  @override
  String get importSubtitle => '从 .txt 备份文件中导入测量数据。';

  @override
  String get amoled => '纯黑模式';

  @override
  String get amoledSubtitle => '暗色主题使用纯黑色背景。';

  @override
  String get reset => '重置应用';

  @override
  String get factoryReset => '重置应用';

  @override
  String get factoryResetSubtitle => '重置所有选项并清除全部测量数据。';

  @override
  String get factoryResetDialog => '您确定要将应用重置吗？这将重置所有选项以及清除所有测量数据。注意：该操作无法撤销。';

  @override
  String get delete => '删除';

  @override
  String get importingAbort => '已取消导入。';

  @override
  String get importDialog => '导入所有测量数据。注意：此操作无法撤销！';

  @override
  String get home => '主页';

  @override
  String get yes => '确定';

  @override
  String get ok => '确定';

  @override
  String get save => '保存';

  @override
  String get edit => '编辑';

  @override
  String get backup => '备份';

  @override
  String get time => '时间';

  @override
  String get assets => '资产项';

  @override
  String get packages => '代码库';

  @override
  String get loading => '加载中';

  @override
  String get measurements => '测量数据';

  @override
  String get version => '版本号';

  @override
  String get tpl => '第三方许可证';

  @override
  String get licence => '许可证';

  @override
  String get sourcecode => '源代码';

  @override
  String get openIssue => '提出问题（提交 issue）';

  @override
  String undertpl({
    required String years,
    required String author,
    required String licence,
  }) {
    return '© $years 由 $author 根据 $licence 许可协议保留所有权利';
  }

  @override
  String get addWeight => '输入您的体重';

  @override
  String get addHeight => '输入您的身高(cm)';

  @override
  String get height => 'height';

  @override
  String get target => 'target';

  @override
  String get interpolation => '插值(体重预测算法)';

  @override
  String get personalization => 'personalization';

  @override
  String get strength => '插值强度';

  @override
  String get none => '无';

  @override
  String get soft => '弱';

  @override
  String get medium => '中';

  @override
  String get strong => '强';

  @override
  String get welcome => '欢迎';

  @override
  String get onBoarding1 =>
      '这款简约 、基于 Material-You 设计的应用程序将帮助您达到理想体重！无论您是想增重、减肥还是仅仅想保持体重： 可靠的体重预测与多样的统计分析有助于您持续掌握体重状况\n\n 现在就加入我们的社区，监测自己的体重变化\n🐺🤸‍♀️🏋‍♀️🧘‍♂️🏆🥇';

  @override
  String get onBoarding2 => '从六个主题中挑选一个，个性化您的应用程序。哪一个最能表达您的感受？';

  @override
  String get onBoarding3 =>
      '感谢您使用我们的应用程序🙂\n\n 如果您喜欢这个应用，我们将非常期待收到您的反馈。欢迎您在 Github 上做出贡献或请我们喝杯咖啡。作为回报，我们将为您屏蔽烦人的、涉及隐私的广告。';

  @override
  String get onBoarding2Title => '主题风格';

  @override
  String get onBoarding3Title => '隐私';

  @override
  String get skip => '跳过';

  @override
  String get startApp => '开始';

  @override
  String get targetWeight => '目标体重';

  @override
  String get targetWeightMotivation =>
      '设定目标体重非常重要，是朝着正确方向迈出的一步。有了目标，就会激励自己为实现目标做出更多努力。';

  @override
  String get targetWeightShort => '目标';

  @override
  String get addUserName => '我们该如何称呼您？';

  @override
  String get name => 'name';

  @override
  String get addTargetWeight => '填写目标体重';

  @override
  String get intro1 => '点击';

  @override
  String get intro2 => '开始记录';

  @override
  String get intro3 => '今天是个好日子，开始您的第一次测量吧！';

  @override
  String get faqtext =>
      '在这里，您可以找到一些常见问题的答案。如果您有任何其他问题，请随时在 Github 中提交 issue 并参与讨论。';

  @override
  String get faq_q1 => '软件缺少某项功能，它什么时候能被实现？';

  @override
  String get faq_a1 =>
      '我们利用业余时间维护这个应用程序，并努力使其保持流畅和简洁。我们认为添加过多的功能会降低它的易用性。如果您认为我们缺少某个关键功能，请随时提出问题或合并请求。';

  @override
  String get faq_q2 => '我能再看一遍应用介绍/起始页吗？';

  @override
  String get faq_a2 => '当然可以！只需点击下面这个按钮。';

  @override
  String get faq_a2_widget => '返回起始页';

  @override
  String get faq_q3 => '应用程序图标显示的是什么？';

  @override
  String get faq_a3 => '一只坐着嚎叫的狼，它的尾巴被字母 \"t \"和字母 \"r \"遮住了一部分。';

  @override
  String get faq_q4 => '我可以输入低于50公斤/110磅/7.9英石的目标体重吗？';

  @override
  String get faq_a4 =>
      '是的，但需要提供您的身高。\n\n厌食症是一种严重疾病，由于社交媒体上存在大量不良示范，正日益成为影响整个社会的问题。为支持预防工作，我们不允许设定低于 50公斤/110磅/7.9英石 的目标体重。通过输入身高，我们将根据身体质量指数（BMI）18.5为您计算最低目标体重。';

  @override
  String get target_weight_warning =>
      '厌食症是一种严重疾病，由于社交媒体上存在大量不良示范，正日益成为影响整个社会的问题。为支持预防工作，我们不允许设定低于 50公斤/110磅/7.9英石 的目标体重以及身体质量指数（BMI）低于18.5。';

  @override
  String get max => '最大值';

  @override
  String get min => '最小值';

  @override
  String get change => '变化';

  @override
  String get totalChange => '总变化';

  @override
  String get schemeVariant => '其他的颜色方案';

  @override
  String get schemeVariantDescription =>
      'Choose a variant to determine how the color scheme is created from the selected seed color.';

  @override
  String get themeDescription =>
      'Choose a seed color to determine the color scheme.';

  @override
  String get additionalSettings => 'additional settings';

  @override
  String get mean => '平均值';

  @override
  String get measurementFrequency => '测量频率';

  @override
  String get targetWeightReached => '您达到了目标体重！';

  @override
  String get targetWeightReachedIn => '距离目标体重';

  @override
  String get maxStreak => '最长连续记录';

  @override
  String get currentStreak => '当前连续记录';

  @override
  String get timeSinceFirstMeasurement => '自首次测量已过';

  @override
  String get firstDay => '一周的第一天';

  @override
  String get highContrast => '高对比度模式';

  @override
  String get bmi => 'BMI';

  @override
  String get back => 'back';

  @override
  String get userDialogTitle => 'User settings';

  @override
  String get importLongDescription =>
      'You can import data. This will not delete your existing data and any duplicate entries will be ignored. \'txt\' files from trale and \'csv\' files from OpenScales are supported. In \'csv\' files, the columns must be named \'weight\' and \'datetime\'; otherwise, the first column will be parsed as a date and the second as a weight. If you are using a custom \'txt\' file, it should have one of the following formats:';

  @override
  String get donation => 'Donation';

  @override
  String get donationSubtitle => 'Support the development of trale';

  @override
  String get customization => 'Customization';

  @override
  String get personalizationTitle => 'Personalization';

  @override
  String get personalizationSubtitle => 'Customize your experience';

  @override
  String get themeSubtitle => 'Set the color scheme';

  @override
  String get languageSubtitle => 'Set the language';

  @override
  String get dataSettings => 'Data settings';

  @override
  String get importAndExport => 'Import and export';

  @override
  String get importAndExportSubtitle => 'Save and load your data';

  @override
  String get aboutTheApp => 'About the app';

  @override
  String get faqSubtitle => 'Find answers to common questions';

  @override
  String get aboutSubtitle => 'Version and license information';

  @override
  String interpolationExplanation({required String noneInterpol}) {
    return 'Interpolation uses state-of-the-art Gaussian filtering to smooth your weight curve and create a clearer trend. Higher strength levels reduce daily fluctuations but may hide short-term changes. Choose \'$noneInterpol\' to see your raw measurements, though extrapolation will still use soft smoothing.';
  }

  @override
  String get unitTitle => 'Unit';

  @override
  String get dateSettings => 'Date settings';

  @override
  String get format => 'Format';

  @override
  String get defaultFormat => 'Default';

  @override
  String get openIssueSubtitle => 'Help improve the app by providing feedback.';

  @override
  String get aboutDescription1 =>
      'A simple weight log with short-term extrapolation.';

  @override
  String get aboutDescription2 =>
      'Your privacy is respected. No revenue sources in the app, nor error logs sent. Please open an issue if you have problems.';

  @override
  String get aboutDescription3 =>
      'Made by two devs with little spare time. Consider contributing or donating.';

  @override
  String get measurementDeleted => 'Measurement was deleted.';

  @override
  String get undo => 'Undo';

  @override
  String get measurementHintTitle => 'Edit measurements';

  @override
  String get measurementHintSubtitle =>
      'Long press on a measurement to edit or delete it. Swipe this message to dismiss.';
}

/// The translations for Chinese, using the Han script (`zh_Hant`).
class AppLocalizationsZhHant extends AppLocalizationsZh {
  AppLocalizationsZhHant() : super('zh_Hant');

  @override
  String get experimentalFeatures => '實驗性功能';

  @override
  String get looseWeight => '減重';

  @override
  String get gainWeight => '增重';

  @override
  String get looseWeightSubtitle => '增/減重切換';

  @override
  String get days => '天數';

  @override
  String get weeks => '週數';

  @override
  String get week => '週';

  @override
  String get months => '月';

  @override
  String get month => '月';

  @override
  String get years => '年';

  @override
  String get year => '年';

  @override
  String get never => '從不';

  @override
  String get weekly => '每週';

  @override
  String get biweekly => '兩週';

  @override
  String get monthly => '每月';

  @override
  String get quarterly => '每季';

  @override
  String get backupReminder => '請定期備份';

  @override
  String get backupReminderButton => '備份';

  @override
  String get backupSuccess => '成功匯出備份';

  @override
  String get backupInterval => '間隔';

  @override
  String get lastBackup => '上次備份';

  @override
  String get nextBackup => '下次備份';

  @override
  String get stats => '統計資料';

  @override
  String get unit => '單位';

  @override
  String get date => '日期';

  @override
  String get weight => '重量';

  @override
  String get user => '使用者資訊';

  @override
  String get userSettings => '使用者設定';

  @override
  String get dangerzone => '清除資料';

  @override
  String get settings => '設定';

  @override
  String get faq => '常見問題';

  @override
  String get about => '關於';

  @override
  String get defaultLang => '系統預設';

  @override
  String get language => '語言';

  @override
  String get theme => '主題';

  @override
  String get darkmode => '暗黑模式';

  @override
  String get lightmode => '亮光模式';

  @override
  String get systemmode => '系統';

  @override
  String get export => '輸出測量資料';

  @override
  String get exportSubtitle => '導出所有數據';

  @override
  String get exportDialog => '導出數據到外部儲存';

  @override
  String get open => '開啟';

  @override
  String get abort => '取消';

  @override
  String get import => '導入備份資料';

  @override
  String get importSubtitle => '導入txt備份資料檔';

  @override
  String get amoled => '純黑模式';

  @override
  String get amoledSubtitle => '暗色主題使用純黑背景';

  @override
  String get reset => '重新設定';

  @override
  String get factoryReset => '全部重設';

  @override
  String get factoryResetSubtitle => '所有設定和數據將被刪除';

  @override
  String get factoryResetDialog => '確定重設？';

  @override
  String get delete => '刪除';

  @override
  String get importingAbort => '已取消導入';

  @override
  String get home => '主頁';

  @override
  String get yes => '確定';

  @override
  String get ok => '好的';

  @override
  String get save => '保存';

  @override
  String get edit => '編輯';

  @override
  String get backup => '備份';

  @override
  String get time => '時間';
}
