// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Norwegian Bokmål (`nb`).
class AppLocalizationsNb extends AppLocalizations {
  AppLocalizationsNb([String locale = 'nb']) : super(locale);

  @override
  String get achievements => 'Oppnåelser';

  @override
  String get experimentalFeatures => 'experimental features';

  @override
  String get looseWeight => 'Lose weight';

  @override
  String get gainWeight => 'Gain weight';

  @override
  String get looseWeightSubtitle =>
      'Switching between losing or gaining weight.';

  @override
  String get days => 'days';

  @override
  String get weeks => 'weeks';

  @override
  String get week => 'week';

  @override
  String get months => 'months';

  @override
  String get month => 'month';

  @override
  String get years => 'years';

  @override
  String get year => 'year';

  @override
  String get never => 'never';

  @override
  String get weekly => 'weekly';

  @override
  String get biweekly => 'biweekly';

  @override
  String get monthly => 'monthly';

  @override
  String get quarterly => 'quarterly';

  @override
  String get backupReminder => 'Please back up regularly';

  @override
  String get backupReminderButton => 'back up';

  @override
  String get backupSuccess => 'Backup successfully exported';

  @override
  String get backupInterval => 'Interval';

  @override
  String get lastBackup => 'last backup';

  @override
  String get nextBackup => 'next backup';

  @override
  String get stats => 'Statistikk';

  @override
  String get trale => 'trale';

  @override
  String get unit => 'Måleenheter';

  @override
  String get date => 'Dato';

  @override
  String get weight => 'Vekt';

  @override
  String get user => 'Brukerprofil';

  @override
  String get userSettings => 'Brukerinnstillinger';

  @override
  String get dangerzone => 'Faresone';

  @override
  String get settings => 'Innstillinger';

  @override
  String get faq => 'O-S-S';

  @override
  String get about => 'Om';

  @override
  String get defaultLang => 'Systemforvalg';

  @override
  String get language => 'Språk';

  @override
  String get theme => 'Drakt';

  @override
  String get translate => 'translate';

  @override
  String get translateSubtitle => 'Help translate the app';

  @override
  String get darkmode => 'Mørk';

  @override
  String get lightmode => 'Lys';

  @override
  String get systemmode => 'System';

  @override
  String get export => 'Eksporter alle målinger';

  @override
  String get exportSubtitle =>
      'Dette tilbyr alle målinger til alle programmer.';

  @override
  String get exportDialog =>
      'Dette eksporterer alle målinger til eksternlagring. Skrivetilgang kreves.';

  @override
  String get open => 'Åpne';

  @override
  String get abort => 'Avbryt';

  @override
  String get import => 'Importer sikkerhetskopi';

  @override
  String get importSubtitle => 'Importer målinger fra .txt-sikkerhetskopifil.';

  @override
  String get amoled => 'Svart';

  @override
  String get amoledSubtitle => 'Endre bakgrunnsfarge til svart for mørk drakt.';

  @override
  String get reset => 'Tilbakestill program';

  @override
  String get factoryReset => 'Fabrikkinnstilling';

  @override
  String get factoryResetSubtitle =>
      'Tilbakestill alle innstillinger og slett alle målinger.';

  @override
  String get factoryResetDialog =>
      'Tilbakestill programmet til forvalg? Dette sletter alle innstillinger, og tillagte målinger. Dette kan ikke angres.';

  @override
  String get delete => 'Slett';

  @override
  String get importingAbort => 'Import avbrutt.';

  @override
  String get importDialog =>
      'Inkluder alle målinger i nåværende database. Dette kan ikke angres.';

  @override
  String get home => 'Hjem';

  @override
  String get yes => 'Ja';

  @override
  String get ok => 'OK';

  @override
  String get save => 'Lagre';

  @override
  String get edit => 'Rediger';

  @override
  String get backup => 'Sikkerhetskopi';

  @override
  String get time => 'Tid';

  @override
  String get assets => 'gjenstander';

  @override
  String get packages => 'pakker';

  @override
  String get loading => 'Laster inn';

  @override
  String get measurements => 'Målinger';

  @override
  String get version => 'Versjon';

  @override
  String get tpl => 'Tredjepartslisenser';

  @override
  String get licence => 'Lisens';

  @override
  String get sourcecode => 'Kildekode';

  @override
  String get openIssue => 'Åpne feilrapport';

  @override
  String undertpl({
    required String years,
    required String author,
    required String licence,
  }) {
    return '© $years av $author med $licence-lisens';
  }

  @override
  String get addWeight => 'Skriv inn din vekt';

  @override
  String get addHeight => 'Enter your height';

  @override
  String get height => 'height';

  @override
  String get target => 'target';

  @override
  String get interpolation => 'interpolasjon';

  @override
  String get personalization => 'personalization';

  @override
  String get strength => 'strength';

  @override
  String get none => 'Ingen';

  @override
  String get soft => 'Myk';

  @override
  String get medium => 'Middels';

  @override
  String get strong => 'Høy';

  @override
  String get welcome => 'Velkommen';

  @override
  String get onBoarding1 =>
      'Et enkelt program som hjelper deg å legge på deg eller ta av deg vekt, i materiell deig. Pålitelige forespeilinger og sirlig statistikk for å hjelpe deg å følge din plan.\n\nTa del i gemenskapen i dag og finn din idealvekt.\n🐺🤸‍♀️🏋‍♀️🧘‍♂️🏆🥇';

  @override
  String get onBoarding2 =>
      'Velg én av seks drakter for å tilpasse programmet deg. Hvilken synes du kler deg?';

  @override
  String get onBoarding3 =>
      'Takk for at du bruker programmet. 🙂\n\nGi gjerne tilbakemelding, send noen kroner på GitHub, eller kjøp kaffe. Til gjengjeld gir vi deg ingen personvernskrenkende reklame.';

  @override
  String get onBoarding2Title => 'Stil';

  @override
  String get onBoarding3Title => 'Personvern';

  @override
  String get skip => 'Hopp over';

  @override
  String get startApp => 'Start';

  @override
  String get targetWeight => 'Målvekt';

  @override
  String get targetWeightMotivation =>
      'Å sette en idealvekt er et viktig steg i rett retning. Å ha et mål motiverer deg mer til å oppnå det.';

  @override
  String get targetWeightShort => 'Mål';

  @override
  String get addUserName => 'Hva skal vi kalle deg?';

  @override
  String get name => 'name';

  @override
  String get addTargetWeight => 'Legg til målvekt';

  @override
  String get intro1 => 'Trykk';

  @override
  String get intro2 => 'Oppstartsinstruks';

  @override
  String get intro3 => 'I dag er en god dag for første måling.';

  @override
  String get faqtext =>
      'Her finner du svar på ofte stilte spørsmål. Hvis du har andre kan du bruke vårt GitHub-kodelager.';

  @override
  String get faq_q1 => 'Funksjon X mangler. Når vil det bli implementert?';

  @override
  String get faq_a1 =>
      'Programmet vedlikeholdes på fritiden og vi prøver å holde det rent og enkelt. Mange funksjoner gjør fort ting mindre brukbart. Hvis du tror noe essensielt mangler kan du fortelle oss om det eller lage en flettingsforespørsel.';

  @override
  String get faq_q2 => 'Kan jeg se oppstartsinstruksen igjen?';

  @override
  String get faq_a2 => 'Ja. Trykk på ikonet nedenfor.';

  @override
  String get faq_a2_widget => 'Tilbake til oppstartsinstruksen';

  @override
  String get faq_q3 => 'Hva viser programikonet?';

  @override
  String get faq_a3 =>
      'En ulv som sitter, og bokstaven «r» der halen er delvis skjult av bokstaven «t».';

  @override
  String get faq_q4 =>
      'Can I enter a target weight below 50kg / 110 lb / 7.9 st?';

  @override
  String get faq_a4 =>
      'Yes, by providing your height.\n\nAnorexia is a serious disease that is increasingly becoming a problem for society as a whole, partly due to the many negative examples on social media. To support prevention efforts, we do not allow target weights below 50 kg / 110 lb / 7.9 st. Entering your height allows us to calculate a minimum target weight corresponding to a BMI of 18.5.';

  @override
  String get target_weight_warning =>
      'Anorexia is a serious disease that is increasingly becoming a problem for society as a whole, partly due to the many negative examples on social media. To support prevention efforts, we do not allow target weights below 50 kg / 110 lb / 7.9 st and BMIs below 18.5.';

  @override
  String get max => 'max';

  @override
  String get min => 'min';

  @override
  String get change => 'change';

  @override
  String get totalChange => 'total change';

  @override
  String get schemeVariant => 'Scheme variant';

  @override
  String get schemeVariantDescription =>
      'Choose a variant to determine how the color scheme is created from the selected seed color.';

  @override
  String get themeDescription =>
      'Choose a seed color to determine the color scheme.';

  @override
  String get additionalSettings => 'additional settings';

  @override
  String get mean => 'mean';

  @override
  String get measurementFrequency => 'measurement frequency';

  @override
  String get targetWeightReached => 'you reached your target weight!';

  @override
  String get targetWeightReachedIn => 'left to reach target weight';

  @override
  String get maxStreak => 'longest streak';

  @override
  String get currentStreak => 'current streak';

  @override
  String get timeSinceFirstMeasurement => 'time since first measurement';

  @override
  String get firstDay => 'Første dagen';

  @override
  String get highContrast => 'High contrast';

  @override
  String get bmi => 'BMI';

  @override
  String get back => 'back';

  @override
  String get userDialogTitle => 'User settings';

  @override
  String get importLongDescription =>
      'You can import data. This will not delete your existing data and any duplicate entries will be ignored. \'txt\' files from trale and \'csv\' files from OpenScales are supported. In \'csv\' files, the columns must be named \'weight\' and \'datetime\'; otherwise, the first column will be parsed as a date and the second as a weight. If you are using a custom \'txt\' file, it should have one of the following formats:';

  @override
  String get donation => 'Donation';

  @override
  String get donationSubtitle => 'Support the development of trale';

  @override
  String get customization => 'Customization';

  @override
  String get personalizationTitle => 'Personalization';

  @override
  String get personalizationSubtitle => 'Customize your experience';

  @override
  String get themeSubtitle => 'Set the color scheme';

  @override
  String get languageSubtitle => 'Set the language';

  @override
  String get dataSettings => 'Data settings';

  @override
  String get importAndExport => 'Import and export';

  @override
  String get importAndExportSubtitle => 'Save and load your data';

  @override
  String get aboutTheApp => 'About the app';

  @override
  String get faqSubtitle => 'Find answers to common questions';

  @override
  String get aboutSubtitle => 'Version and license information';

  @override
  String interpolationExplanation({required String noneInterpol}) {
    return 'Interpolation uses state-of-the-art Gaussian filtering to smooth your weight curve and create a clearer trend. Higher strength levels reduce daily fluctuations but may hide short-term changes. Choose \'$noneInterpol\' to see your raw measurements, though extrapolation will still use soft smoothing.';
  }

  @override
  String get unitTitle => 'Unit';

  @override
  String get dateSettings => 'Date settings';

  @override
  String get format => 'Format';

  @override
  String get defaultFormat => 'Default';

  @override
  String get openIssueSubtitle => 'Help improve the app by providing feedback.';

  @override
  String get aboutDescription1 =>
      'A simple weight log with short-term extrapolation.';

  @override
  String get aboutDescription2 =>
      'Your privacy is respected. No revenue sources in the app, nor error logs sent. Please open an issue if you have problems.';

  @override
  String get aboutDescription3 =>
      'Made by two devs with little spare time. Consider contributing or donating.';

  @override
  String get measurementDeleted => 'Measurement was deleted.';

  @override
  String get undo => 'Undo';

  @override
  String get measurementHintTitle => 'Edit measurements';

  @override
  String get measurementHintSubtitle =>
      'Long press on a measurement to edit or delete it. Swipe this message to dismiss.';
}
