// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Finnish (`fi`).
class AppLocalizationsFi extends AppLocalizations {
  AppLocalizationsFi([String locale = 'fi']) : super(locale);

  @override
  String get achievements => 'Saavutukset';

  @override
  String get experimentalFeatures => 'experimental features';

  @override
  String get looseWeight => 'Lose weight';

  @override
  String get gainWeight => 'Gain weight';

  @override
  String get looseWeightSubtitle =>
      'Switching between losing or gaining weight.';

  @override
  String get days => 'days';

  @override
  String get weeks => 'weeks';

  @override
  String get week => 'week';

  @override
  String get months => 'months';

  @override
  String get month => 'month';

  @override
  String get years => 'years';

  @override
  String get year => 'year';

  @override
  String get never => 'never';

  @override
  String get weekly => 'weekly';

  @override
  String get biweekly => 'biweekly';

  @override
  String get monthly => 'monthly';

  @override
  String get quarterly => 'quarterly';

  @override
  String get backupReminder => 'Please back up regularly';

  @override
  String get backupReminderButton => 'back up';

  @override
  String get backupSuccess => 'Backup successfully exported';

  @override
  String get backupInterval => 'Interval';

  @override
  String get lastBackup => 'last backup';

  @override
  String get nextBackup => 'next backup';

  @override
  String get stats => 'Tilastot';

  @override
  String get trale => 'trale';

  @override
  String get unit => 'Yksiköt';

  @override
  String get date => 'Päivämäärä';

  @override
  String get weight => 'Paino';

  @override
  String get user => 'Käyttäjäprofiili';

  @override
  String get userSettings => 'Käyttäjäasetukset';

  @override
  String get dangerzone => 'Vaaravyöhyke';

  @override
  String get settings => 'Asetukset';

  @override
  String get faq => 'FAQ';

  @override
  String get about => 'Tietoja';

  @override
  String get defaultLang => 'Järjestelmäoletus';

  @override
  String get language => 'Kieli';

  @override
  String get theme => 'Teema';

  @override
  String get translate => 'translate';

  @override
  String get translateSubtitle => 'Help translate the app';

  @override
  String get darkmode => 'Tumma';

  @override
  String get lightmode => 'Vaalea';

  @override
  String get systemmode => 'Järjestelmä';

  @override
  String get export => 'Vie kaikki mittaukset';

  @override
  String get exportSubtitle =>
      'Tämä paljastaa kaikki mittaukset kaikille sovelluksille.';

  @override
  String get exportDialog =>
      'Tämä vie kaikki mittauksesi ulkoiseen tallennustilaan. Kirjoitusoikeudet vaaditaan.';

  @override
  String get open => 'Avaa';

  @override
  String get abort => 'Keskeytä';

  @override
  String get import => 'Tuo varmuuskopio';

  @override
  String get importSubtitle => 'Tuo mittaukset .txt varmuuskopiotiedostosta.';

  @override
  String get amoled => 'Musta';

  @override
  String get amoledSubtitle =>
      'Vaihda taustaväri täysin mustaan tummassa tilassa.';

  @override
  String get reset => 'Nollaa sovellus';

  @override
  String get factoryReset => 'Palauta tehdasasetuksiin';

  @override
  String get factoryResetSubtitle =>
      'Nollaa kaikki asetukset ja poista kaikki mittaukset.';

  @override
  String get factoryResetDialog =>
      'Asetetaanko sovellus alkutilaan? Tämä poistaa kaikki asetukset ja lisätyt mittaukset. Tätä ei voi kumota.';

  @override
  String get delete => 'Poista';

  @override
  String get importingAbort => 'Tuonti keskeytetty.';

  @override
  String get importDialog =>
      'Sisällytä kaikki mittaukset nykyiseen tietokantaan. Tätä ei voi kumota!';

  @override
  String get home => 'Koti';

  @override
  String get yes => 'Kyllä';

  @override
  String get ok => 'OK';

  @override
  String get save => 'Tallenna';

  @override
  String get edit => 'Muokkaa';

  @override
  String get backup => 'Varmuuskopioi';

  @override
  String get time => 'Aika';

  @override
  String get assets => 'resurssit';

  @override
  String get packages => 'paketit';

  @override
  String get loading => 'Ladataan';

  @override
  String get measurements => 'Mittaukset';

  @override
  String get version => 'Versio';

  @override
  String get tpl => 'Kolmannen osapuolen lisenssit';

  @override
  String get licence => 'Lisenssi';

  @override
  String get sourcecode => 'Lähdekoodi';

  @override
  String get openIssue => 'Avaa ongelma';

  @override
  String undertpl({
    required String years,
    required String author,
    required String licence,
  }) {
    return '© $years by $author under $licence licence';
  }

  @override
  String get addWeight => 'Syötä painosi';

  @override
  String get addHeight => 'Enter your height';

  @override
  String get height => 'height';

  @override
  String get target => 'target';

  @override
  String get interpolation => 'interpolaatio';

  @override
  String get personalization => 'personalization';

  @override
  String get strength => 'strength';

  @override
  String get none => 'Ei mitään';

  @override
  String get soft => 'Pehmeä';

  @override
  String get medium => 'Keskisuuri';

  @override
  String get strong => 'Vahva';

  @override
  String get welcome => 'Tervetuloa';

  @override
  String get onBoarding1 =>
      'Tämä yksinkertainen Material-You-design-sovellus auttaa sinua saavuttamaan unelmapainosi! Halusitpa sitten lihoa, laihtua tai vain säilyttää painosi: Luotettavat painoennusteet ja monipuoliset tilastot auttavat sinua pysymään raiteilla.\n\n Liity yhteisöömme tänään seurataksesi itseäsi. \n🐺🤸‍♀️🏋‍♀️🧘‍♂️🏆🥇';

  @override
  String get onBoarding2 =>
      'Valitse yksi kuudesta teemasta muokataksesi sovellustasi. Mikä niistä ilmaisee tunteitasi parhaiten?';

  @override
  String get onBoarding3 =>
      'Kiitos, että kokeilet sovellustamme. 🙂\n\n Jos pidät sovelluksesta, olisimme erittäin iloisia palautteestasi, lahjoituksestasi Githubista tai kahvista. Vastineeksi säästämme sinut ärsyttäviltä ja tietosuojaasi mainoksilta.';

  @override
  String get onBoarding2Title => 'Tyyli';

  @override
  String get onBoarding3Title => 'Tietosuoja';

  @override
  String get skip => 'Ohita';

  @override
  String get startApp => 'Aloita';

  @override
  String get targetWeight => 'Tavoitepaino';

  @override
  String get targetWeightMotivation =>
      'Tavoitepainon asettaminen on erittäin tärkeää ja askel oikeaan suuntaan. Tavoitteen pitäminen mielessä motivoi sinua tekemään enemmän sen saavuttamiseksi.';

  @override
  String get targetWeightShort => 'Tavoite';

  @override
  String get addUserName => 'Millä nimellä kutsumme sinua?';

  @override
  String get name => 'name';

  @override
  String get addTargetWeight => 'Lisää tavoitepaino';

  @override
  String get intro1 => 'Paina';

  @override
  String get intro2 => 'aloittaaksesi';

  @override
  String get intro3 =>
      'Tänään on hyvä päivä aloittaa ensimmäisellä mittauksella!';

  @override
  String get faqtext =>
      'Täältä löydät vastaukset joihinkin kysytyimpiin kysymyksiin. Jos sinulla on muita kysymyksiä, voit avata ongelman Githubissa.';

  @override
  String get faq_q1 =>
      'Ominaisuus/toiminto X puuttuu. Milloin se tulee käyttöön?';

  @override
  String get faq_a1 =>
      'Sovellusta ylläpidetään vapaa-ajallamme ja pyrimme pitämään sovelluksen tyylikkäänä ja yksinkertaisena. Uskomme, että liian monien ominaisuuksien lisääminen tekee sovelluksesta vähemmän käyttökelpoisen. Jos uskot, että meiltä puuttuu jokin keskeinen ominaisuus, voit avata ongelman tai liittämispyynnön.';

  @override
  String get faq_q2 => 'Voinko nähdä uudelleen esittelyn?';

  @override
  String get faq_a2 => 'Kyllä! Paina vain alla olevaa kuvaketta.';

  @override
  String get faq_a2_widget => 'Palaa esittelyyn';

  @override
  String get faq_q3 => 'Mitä sovelluskuvake näyttää?';

  @override
  String get faq_a3 =>
      'Ulvovaa sutta istumassa, sen häntää peittää osittain kirjain \"t\" ja kirjain \"r\".';

  @override
  String get faq_q4 =>
      'Can I enter a target weight below 50kg / 110 lb / 7.9 st?';

  @override
  String get faq_a4 =>
      'Yes, by providing your height.\n\nAnorexia is a serious disease that is increasingly becoming a problem for society as a whole, partly due to the many negative examples on social media. To support prevention efforts, we do not allow target weights below 50 kg / 110 lb / 7.9 st. Entering your height allows us to calculate a minimum target weight corresponding to a BMI of 18.5.';

  @override
  String get target_weight_warning =>
      'Anoreksia on vakava sairaus, josta on tulossa yhä enemmän koko yhteiskunnan ongelma, osittain sosiaalisen median monien negatiivisten esimerkkien vuoksi. Osana panostamme sen ennaltaehkäisyyn, alle 50 kg / 110 lb / 7,9 st tavoitepaino ei ole mahdollinen.';

  @override
  String get max => 'max';

  @override
  String get min => 'min';

  @override
  String get change => 'change';

  @override
  String get totalChange => 'total change';

  @override
  String get schemeVariant => 'Scheme variant';

  @override
  String get schemeVariantDescription =>
      'Choose a variant to determine how the color scheme is created from the selected seed color.';

  @override
  String get themeDescription =>
      'Choose a seed color to determine the color scheme.';

  @override
  String get additionalSettings => 'additional settings';

  @override
  String get mean => 'mean';

  @override
  String get measurementFrequency => 'measurement frequency';

  @override
  String get targetWeightReached => 'you reached your target weight!';

  @override
  String get targetWeightReachedIn => 'left to reach target weight';

  @override
  String get maxStreak => 'longest streak';

  @override
  String get currentStreak => 'current streak';

  @override
  String get timeSinceFirstMeasurement => 'time since first measurement';

  @override
  String get firstDay => 'Ensimmäinen päivä';

  @override
  String get highContrast => 'High contrast';

  @override
  String get bmi => 'BMI';

  @override
  String get back => 'back';

  @override
  String get userDialogTitle => 'User settings';

  @override
  String get importLongDescription =>
      'You can import data. This will not delete your existing data and any duplicate entries will be ignored. \'txt\' files from trale and \'csv\' files from OpenScales are supported. In \'csv\' files, the columns must be named \'weight\' and \'datetime\'; otherwise, the first column will be parsed as a date and the second as a weight. If you are using a custom \'txt\' file, it should have one of the following formats:';

  @override
  String get donation => 'Donation';

  @override
  String get donationSubtitle => 'Support the development of trale';

  @override
  String get customization => 'Customization';

  @override
  String get personalizationTitle => 'Personalization';

  @override
  String get personalizationSubtitle => 'Customize your experience';

  @override
  String get themeSubtitle => 'Set the color scheme';

  @override
  String get languageSubtitle => 'Set the language';

  @override
  String get dataSettings => 'Data settings';

  @override
  String get importAndExport => 'Import and export';

  @override
  String get importAndExportSubtitle => 'Save and load your data';

  @override
  String get aboutTheApp => 'About the app';

  @override
  String get faqSubtitle => 'Find answers to common questions';

  @override
  String get aboutSubtitle => 'Version and license information';

  @override
  String interpolationExplanation({required String noneInterpol}) {
    return 'Interpolation uses state-of-the-art Gaussian filtering to smooth your weight curve and create a clearer trend. Higher strength levels reduce daily fluctuations but may hide short-term changes. Choose \'$noneInterpol\' to see your raw measurements, though extrapolation will still use soft smoothing.';
  }

  @override
  String get unitTitle => 'Unit';

  @override
  String get dateSettings => 'Date settings';

  @override
  String get format => 'Format';

  @override
  String get defaultFormat => 'Default';

  @override
  String get openIssueSubtitle => 'Help improve the app by providing feedback.';

  @override
  String get aboutDescription1 =>
      'A simple weight log with short-term extrapolation.';

  @override
  String get aboutDescription2 =>
      'Your privacy is respected. No revenue sources in the app, nor error logs sent. Please open an issue if you have problems.';

  @override
  String get aboutDescription3 =>
      'Made by two devs with little spare time. Consider contributing or donating.';

  @override
  String get measurementDeleted => 'Measurement was deleted.';

  @override
  String get undo => 'Undo';

  @override
  String get measurementHintTitle => 'Edit measurements';

  @override
  String get measurementHintSubtitle =>
      'Long press on a measurement to edit or delete it. Swipe this message to dismiss.';
}
