// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for German (`de`).
class AppLocalizationsDe extends AppLocalizations {
  AppLocalizationsDe([String locale = 'de']) : super(locale);

  @override
  String get achievements => 'Erfolge';

  @override
  String get experimentalFeatures => 'Experimentelle Funktion';

  @override
  String get looseWeight => 'Gewicht verlieren';

  @override
  String get gainWeight => 'Gewicht zunehmen';

  @override
  String get looseWeightSubtitle =>
      'Wechsle zwischen Gewicht verlieren oder Gewicht zunehmen.';

  @override
  String get days => 'Tage';

  @override
  String get weeks => 'Wochen';

  @override
  String get week => 'Woche';

  @override
  String get months => 'Monate';

  @override
  String get month => 'Monat';

  @override
  String get years => 'Jahre';

  @override
  String get year => 'Jahr';

  @override
  String get never => 'Nie';

  @override
  String get weekly => 'wöchentlich';

  @override
  String get biweekly => 'zweiwöchentlich';

  @override
  String get monthly => 'monatlich';

  @override
  String get quarterly => 'quartalsweise';

  @override
  String get backupReminder => 'Bitte regelmässig sichern';

  @override
  String get backupReminderButton => 'Sichern';

  @override
  String get backupSuccess => 'Sicherung erfolgreich exportiert';

  @override
  String get backupInterval => 'Intervall';

  @override
  String get lastBackup => 'letzte Sicherung';

  @override
  String get nextBackup => 'nächste Sicherung';

  @override
  String get stats => 'Statistik';

  @override
  String get trale => 'Trale';

  @override
  String get unit => 'Einheiten';

  @override
  String get date => 'Datum';

  @override
  String get weight => 'Gewicht';

  @override
  String get user => 'Nutzer Profil';

  @override
  String get userSettings => 'Nutzereinstellungen';

  @override
  String get dangerzone => 'Gefahrenbereich';

  @override
  String get settings => 'Einstellungen';

  @override
  String get faq => 'FAQ';

  @override
  String get about => 'Über';

  @override
  String get defaultLang => 'System Sprache';

  @override
  String get language => 'Sprache';

  @override
  String get theme => 'Thema';

  @override
  String get translate => 'translate';

  @override
  String get translateSubtitle => 'Help translate the app';

  @override
  String get darkmode => 'Nachtmodus';

  @override
  String get lightmode => 'Tagmodus';

  @override
  String get systemmode => 'Systemmodus';

  @override
  String get export => 'Exportiere alle Messungen';

  @override
  String get exportSubtitle =>
      'Danach haben alle Apps Zugriff auf alle exportierten Messwerte.';

  @override
  String get exportDialog =>
      'Dies wird alle Messungen in den externen Speicher schreiben. Schreibberechtigung wird benätigt.';

  @override
  String get open => 'Öffnen';

  @override
  String get abort => 'Abbrechen';

  @override
  String get import => 'Importiere Backup';

  @override
  String get importSubtitle => 'Daten aus einem .txt Backup importieren.';

  @override
  String get amoled => 'Schwarz';

  @override
  String get amoledSubtitle =>
      'Ändere Hintegrundfarbe zu Schwarz im Nachtmodus.';

  @override
  String get reset => 'Zurücksetzen';

  @override
  String get factoryReset => 'Auf Werkseinstellungen Zurücksetzen';

  @override
  String get factoryResetSubtitle =>
      'Setzte alle Einstellungen zurück und lösche alle Messungen.';

  @override
  String get factoryResetDialog =>
      'Setzte App auf Werkseinstellungen zurück? Dadurch werden alle Einstellungen zurück gesetzt und Messungen unwideruflich gelöscht.';

  @override
  String get delete => 'Löschen';

  @override
  String get importingAbort => 'Import abgebrochen.';

  @override
  String get importDialog =>
      'Importiere alle Messungen in die aktuelle Messreihe. Dies kann nicht rückgängig gemacht werden!';

  @override
  String get home => 'Start';

  @override
  String get yes => 'Ja';

  @override
  String get ok => 'OK';

  @override
  String get save => 'Speichern';

  @override
  String get edit => 'Bearbeiten';

  @override
  String get backup => 'Sicherung';

  @override
  String get time => 'Uhrzeit';

  @override
  String get assets => 'Assets';

  @override
  String get packages => 'Pakete';

  @override
  String get loading => 'lädt';

  @override
  String get measurements => 'Messungen';

  @override
  String get version => 'Version';

  @override
  String get tpl => 'Drittanbieterlizenz';

  @override
  String get licence => 'Lizenz';

  @override
  String get sourcecode => 'Quellcode';

  @override
  String get openIssue => 'Eröffne Ticket';

  @override
  String undertpl({
    required String years,
    required String author,
    required String licence,
  }) {
    return '© $years von $author unter $licence Lizenz';
  }

  @override
  String get addWeight => 'Gewicht eintragen';

  @override
  String get addHeight => 'Enter your height';

  @override
  String get height => 'height';

  @override
  String get target => 'target';

  @override
  String get interpolation => 'Interpolation';

  @override
  String get personalization => 'personalization';

  @override
  String get strength => 'Stärke';

  @override
  String get none => 'ohne';

  @override
  String get soft => 'schwach';

  @override
  String get medium => 'mittel';

  @override
  String get strong => 'stark';

  @override
  String get welcome => 'Willkommen';

  @override
  String get onBoarding1 =>
      'Diese schlichte App im Material-You-Design hilft Dir dein Traumgewicht zu erreichen! Unabhängig davon ob Du zunehmen, abnehmen oder einfach Dein Gewicht halten willst: Zuverlässige Gewichtsprognosen und vielseitige Statistiken helfen Dir am Ball zu bleiben. \n\n Treten Sie noch heute unserer Community bei, um Ihr Gewicht zu tracken.\n🐺🤸‍♀️🏋‍♀️🧘‍♂️🏆🥇';

  @override
  String get onBoarding2 =>
      'Wähle eines aus sechs Designs aus, um die App zu personalisieren. Welches passt am besten zu Dir?';

  @override
  String get onBoarding3 =>
      'Danke, dass Du unserer App eine Chance gibst. 🙂\n\n Wenn Dir die App gefällt, würden wir uns sehr über dein Feedback, eine Beteiligung auf Github oder einen Kaffee freuen. Im Gegenzug ersparen wir Dir lästige und datenschutzkritische Werbung.';

  @override
  String get onBoarding2Title => 'Stil';

  @override
  String get onBoarding3Title => 'Privatsphäre';

  @override
  String get skip => 'Überspringen';

  @override
  String get startApp => 'Starten';

  @override
  String get targetWeight => 'Zielgewicht';

  @override
  String get targetWeightMotivation =>
      'Sich ein Zielgewicht zu setzen ist sehr wichtig und ein Schritt in die richtige Richtung. Denn ein Ziel vor Augen zu haben motiviert, mehr dafür zu tun.';

  @override
  String get targetWeightShort => 'Ziel';

  @override
  String get addUserName => 'Wie sollen wir dich nennen?';

  @override
  String get name => 'name';

  @override
  String get addTargetWeight => 'Zielgewicht hinzufügen';

  @override
  String get intro1 => 'drücke';

  @override
  String get intro2 => 'um loszulegen';

  @override
  String get intro3 => 'Heute ist ein guter Tag mit dem Wiegen zu starten!';

  @override
  String get faqtext =>
      'Hier findest du Anworten zu den häufigsten Fragen. Falls du weitere Fragen haben solltest kannst du diese gerne in einem Github Issue an uns stellen.';

  @override
  String get faq_q1 => 'Die Funktion X fehlt. Wann wird diese hinzugefügt?';

  @override
  String get faq_a1 =>
      'Wir warten die App in unserer Freizeit und versuchen sie simple und funktional zu halten. Wir glauben, dass zu viele Funktionen die App unhandlich machen. Falls du glaubst, dass eine Hauptfunktionalität fehlt, kannst du gerne ein Ticket auf Github eröffnen.';

  @override
  String get faq_q2 => 'Ist es möglich zum Introscreen zurück zukehren?';

  @override
  String get faq_a2 => 'Ja klar! Klick einfach das folgende Icon.';

  @override
  String get faq_a2_widget => 'Zum Introscreen zurück kehren';

  @override
  String get faq_q3 => 'Was ist auf dem Appicon zu sehen?';

  @override
  String get faq_a3 =>
      'Es zeigt einen heulenden Wolf der auf dem Buchstaben \'r\' sitzt und sein Schwanz ist vom Buchstaben \'t\' teils verdeckt.';

  @override
  String get faq_q4 =>
      'Can I enter a target weight below 50kg / 110 lb / 7.9 st?';

  @override
  String get faq_a4 =>
      'Yes, by providing your height.\n\nAnorexia is a serious disease that is increasingly becoming a problem for society as a whole, partly due to the many negative examples on social media. To support prevention efforts, we do not allow target weights below 50 kg / 110 lb / 7.9 st. Entering your height allows us to calculate a minimum target weight corresponding to a BMI of 18.5.';

  @override
  String get target_weight_warning =>
      'Magersucht ist eine ernstzunehmende Erkrankung, die nicht zuletzt durch die vielen Negativbeispiele in den sozialen Medien zunehmend zu einem gesamtgesellschaftlichen Problem wird. Als Beitrag zur Prävention ist kein Zielgewicht unter 50 kg / 110 lb / 7.9 st möglich.';

  @override
  String get max => 'max.';

  @override
  String get min => 'min';

  @override
  String get change => 'Änderung';

  @override
  String get totalChange => 'Gesamtveränderung';

  @override
  String get schemeVariant => 'Scheme variant';

  @override
  String get schemeVariantDescription =>
      'Choose a variant to determine how the color scheme is created from the selected seed color.';

  @override
  String get themeDescription =>
      'Choose a seed color to determine the color scheme.';

  @override
  String get additionalSettings => 'additional settings';

  @override
  String get mean => 'Durchschnitt';

  @override
  String get measurementFrequency => 'Durchschnittliches Messintervall';

  @override
  String get targetWeightReached => 'Du hast dein Zielgewicht erreicht!';

  @override
  String get targetWeightReachedIn => 'übrig um das Zielgewicht zu erreichen';

  @override
  String get maxStreak => 'längste Serie';

  @override
  String get currentStreak => 'aktuelle Serie';

  @override
  String get timeSinceFirstMeasurement => 'Zeit seit der ersten Messung';

  @override
  String get firstDay => 'Erster Tag';

  @override
  String get highContrast => 'High contrast';

  @override
  String get bmi => 'BMI';

  @override
  String get back => 'back';

  @override
  String get userDialogTitle => 'User settings';

  @override
  String get importLongDescription =>
      'You can import data. This will not delete your existing data and any duplicate entries will be ignored. \'txt\' files from trale and \'csv\' files from OpenScales are supported. In \'csv\' files, the columns must be named \'weight\' and \'datetime\'; otherwise, the first column will be parsed as a date and the second as a weight. If you are using a custom \'txt\' file, it should have one of the following formats:';

  @override
  String get donation => 'Donation';

  @override
  String get donationSubtitle => 'Support the development of trale';

  @override
  String get customization => 'Customization';

  @override
  String get personalizationTitle => 'Personalization';

  @override
  String get personalizationSubtitle => 'Customize your experience';

  @override
  String get themeSubtitle => 'Set the color scheme';

  @override
  String get languageSubtitle => 'Set the language';

  @override
  String get dataSettings => 'Data settings';

  @override
  String get importAndExport => 'Import and export';

  @override
  String get importAndExportSubtitle => 'Save and load your data';

  @override
  String get aboutTheApp => 'About the app';

  @override
  String get faqSubtitle => 'Find answers to common questions';

  @override
  String get aboutSubtitle => 'Version and license information';

  @override
  String interpolationExplanation({required String noneInterpol}) {
    return 'Interpolation uses state-of-the-art Gaussian filtering to smooth your weight curve and create a clearer trend. Higher strength levels reduce daily fluctuations but may hide short-term changes. Choose \'$noneInterpol\' to see your raw measurements, though extrapolation will still use soft smoothing.';
  }

  @override
  String get unitTitle => 'Unit';

  @override
  String get dateSettings => 'Date settings';

  @override
  String get format => 'Format';

  @override
  String get defaultFormat => 'Default';

  @override
  String get openIssueSubtitle => 'Help improve the app by providing feedback.';

  @override
  String get aboutDescription1 =>
      'A simple weight log with short-term extrapolation.';

  @override
  String get aboutDescription2 =>
      'Your privacy is respected. No revenue sources in the app, nor error logs sent. Please open an issue if you have problems.';

  @override
  String get aboutDescription3 =>
      'Made by two devs with little spare time. Consider contributing or donating.';

  @override
  String get measurementDeleted => 'Measurement was deleted.';

  @override
  String get undo => 'Undo';

  @override
  String get measurementHintTitle => 'Edit measurements';

  @override
  String get measurementHintSubtitle =>
      'Long press on a measurement to edit or delete it. Swipe this message to dismiss.';
}
