package voice.core.ui

import androidx.compose.runtime.Composable
import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewmodel.compose.viewModel

@PublishedApi
internal class HoldingViewModel<T>(val value: T) : ViewModel()

@Composable
inline fun <reified T> rememberScoped(
  vararg key: String,
  crossinline create: () -> T,
): T {
  return viewModel(key = T::class.qualifiedName + key.contentToString()) {
    HoldingViewModel(create())
  }.value
}
