// Copyright (c) 2019, the Dart project authors. Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

/// Test data for Locale handling.
///
/// DO NOT EDIT. This file is autogenerated by script.
/// TODO(hugovdm): improve the script and file related ICU bugs.

/// Test data: a map from unnormalized locale names to normalized locale names.
Map<String, String> localeParsingTestData = <String, String>{
  // Simple with normalization
  'Zh': 'zh',
  'zH-cn': 'zh-CN',
  'ZH-Cn': 'zh-CN',
  'zh-cN': 'zh-CN',
  'zh-hans': 'zh-Hans',
  'ZH-HANS-CN': 'zh-Hans-CN',

  // Region codes can be three digits
  'es-419': 'es-419',

  // While language is usually 2 characters, it can also be 3
  'CKB-arab': 'ckb-Arab',

  // With simple canonicalization
  'Iw': 'he',
  'iW': 'he',
  'My-Bu': 'my-MM',

  // "und" is the language tag for undefined language
  'und': 'und',

  // Normalization: sorting of extension subtags
  'en-z-abc-001-foo-fii-bar-u-cu-usd-co-phonebk':
      'en-u-co-phonebk-cu-usd-z-abc-001-foo-fii-bar',

  // Normalises tags, sorts subtags alphabetically
  'UND-lkjh-qw-12345-Abcde-U-Zz-Aaa-Co-Zxc-T-AF-Latn-Za-M0-Bar':
      'und-Lkjh-QW-12345-abcde-t-af-latn-za-m0-bar-u-co-zxc-zz-aaa',

  // Supports multiple "tvalues" for each "tpart"
  'en-u-cu-usd-t-a0-ghi-jkl-b0-abc-def-a-aaa':
      'en-a-aaa-t-a0-ghi-jkl-b0-abc-def-u-cu-usd',

  // Private-use extension subtags do not get sorted
  'en-x-BCDE0123-ABCD0123': 'en-x-bcde0123-abcd0123',
  'en-x-BCDE0123-123456-ABCD0123': 'en-x-bcde0123-123456-abcd0123',

  // Digits in u-extension values
  'en-u-hc-h11': 'en-u-hc-h11',
  'en-u-hc-h23': 'en-u-hc-h23',

  // Digits in t-extension values
  'en-t-m0-c11': 'en-t-m0-c11',
};

/// Invalid Language Tags.
List<String> invalidLocales = <String>[
  'en-',
  '-za',
  'en--za',
  '419',
  'en-t',
  'en-t-',
  'en-t-de-t-fr',
  'en-u',
  'en-u-',
  'en-u-ca-islamic-',
  'en-u-cu-eur-u-co-phonebk',
  'en-x-',
  'en-x-foo-',
  'en-x-abcdefghi',
  'en-z-',
  'en-z-aaa-z-bbb',
];
