# Example Catalog

## [Get started](https://github.com/flutter/packages/blob/main/packages/go_router/example/lib/main.dart)
`flutter run lib/main.dart`

An example to demonstrate a simple two-page app.

## [Sub-routes](https://github.com/flutter/packages/blob/main/packages/go_router/example/lib/sub_routes.dart)
`flutter run lib/sub_routes.dart`

An example to demonstrate an app with multi-level routing.

## [Query parameters and path parameters](https://github.com/flutter/packages/blob/main/packages/go_router/example/lib/path_and_query_parameters.dart)
`flutter run lib/path_and_query_parameters.dart`

An example to demonstrate how to use path parameters and query parameters.

## [Named routes](https://github.com/flutter/packages/blob/main/packages/go_router/example/lib/named_routes.dart)
`flutter run lib/named_routes.dart`

An example to demonstrate how to navigate using named locations instead of URLs.

## [Redirection](https://github.com/flutter/packages/blob/main/packages/go_router/example/lib/redirection.dart)
`flutter run lib/redirection.dart`

An example to demonstrate how to use redirect to handle a synchronous sign-in flow.

## [Asynchronous Redirection](https://github.com/flutter/packages/blob/main/packages/go_router/example/lib/async_redirection.dart)
`flutter run lib/async_redirection.dart`

An example to demonstrate how to use handle a sign-in flow with a stream authentication service.

## [Stateful Nested Navigation](https://github.com/flutter/packages/blob/main/packages/go_router/example/lib/stateful_shell_route.dart)
`flutter run lib/stateful_shell_route.dart`

An example to demonstrate how to use a `StatefulShellRoute` to create stateful nested navigation, with a
`BottomNavigationBar`.

## [Exception Handling](https://github.com/flutter/packages/blob/main/packages/go_router/example/lib/exception_handling.dart)
`flutter run lib/exception_handling.dart`

An example to demonstrate how to handle exception in go_router.

## [Extra Codec](https://github.com/flutter/packages/blob/main/packages/go_router/example/lib/extra_codec.dart)
`flutter run lib/extra_codec.dart`

An example to demonstrate how to use a complex object as extra.

## [Books app](https://github.com/flutter/packages/blob/main/packages/go_router/example/lib/books)
`flutter run lib/books/main.dart`

A fully fledged example that showcases various go_router APIs.
