package de.ntdote.medicalcalendarlog.data

import java.util.Date

data class CalendarEvent(
    val id: Long,
    val title: String,
    val startTime: Date,
    val endTime: Date,
    val calendarId: Long,
    val dosage: Double = 1.0 // Extracted from title or default to 1
)

data class CalendarInfo(
    val id: Long,
    val displayName: String,
    val accountName: String,
    val ownerName: String
)

data class ConcentrationData(
    val templateId: String,
    val concentrations: Map<String, Double>, // drugType -> current concentration
    val peakConcentrations: Map<String, Double>, // drugType -> peak concentration
    val lastEventTime: Date?
) {
    /**
     * Get total concentration across all drugs
     */
    fun getTotalConcentration(): Double {
        return concentrations.values.sum()
    }
    
    /**
     * Get total peak concentration across all drugs
     */
    fun getTotalPeakConcentration(): Double {
        return peakConcentrations.values.sum()
    }
}
