package de.ntdote.medicalcalendarlog.data

import java.util.Date

/**
 * Represents a configuration backup stored in the calendar
 */
data class BackupInfo(
    val eventId: Long,
    val timestamp: Date,
    val versionCode: Int,
    val versionName: String,
    val templateCount: Int,
    val jsonData: String
) {
    /**
     * Get version color based on comparison with current version
     * @param currentVersionCode Current app version code
     * @return Color indicator: same=green, older=orange, newer=red
     */
    fun getVersionColor(currentVersionCode: Int): VersionColor {
        return when {
            versionCode == currentVersionCode -> VersionColor.SAME
            versionCode < currentVersionCode -> VersionColor.OLDER
            else -> VersionColor.NEWER
        }
    }
}

enum class VersionColor {
    SAME,    // Green - same version
    OLDER,   // Orange - older version
    NEWER    // Red - newer version
}
