plugins {
    id("com.android.application") version "8.13.2"
    id("org.jetbrains.kotlin.android") version "2.0.21"
    id("org.jetbrains.kotlin.plugin.compose") version "2.0.21"
    id("org.jetbrains.kotlin.plugin.serialization") version "2.0.21"
}

val repositoryUrl = "https://codeberg.org/svewa/MedicalCalendarLog"

// Task to copy README.md from project root to resources for help screen
tasks.register<Copy>("copyReadme") {
    from(rootProject.file("README.md"))
    into("src/main/res/raw")
    rename { "readme.md" }
}

// Ensure README is copied before building
tasks.named("preBuild") {
    dependsOn("copyReadme")
}

android {
    namespace = "de.ntdote.medicalcalendarlog"
    compileSdk = 36
    
    dependenciesInfo {
        // Disables dependency metadata when building APKs (for IzzyOnDroid/F-Droid)
        includeInApk = false
        // Disables dependency metadata when building Android App Bundles (for Google Play)
        includeInBundle = false
    }
    
    // Disable baseline profiles for reproducible builds
    // Baseline profiles are runtime optimizations that vary between builds
    androidResources {
        ignoreAssetsPattern = "!.git"
    }

    defaultConfig {
        applicationId = "de.ntdote.medicalcalendarlog"
        minSdk = 23
        targetSdk = 36
        versionCode = 41
        versionName = "2.0.1"

        testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"
	        ndk {
		            abiFilters.addAll(listOf("armeabi-v7a", "arm64-v8a", "x86_64"))
        }

    }

            // Play Store signing configuration
            // Only applied when ENABLE_SIGNING environment variable is set to "true"

    buildTypes {
        release {
            isMinifyEnabled = true
            proguardFiles(
                getDefaultProguardFile("proguard-android-optimize.txt"),
                "proguard-rules.pro"
            )
            // Only apply signing config if environment variable is set
            val enableSigning = System.getenv("ENABLE_SIGNING") == "true"
            if (enableSigning) {
            }
        }
        
        // Note: We've simplified the build types to use a single "release" variant
        // for both F-Droid and Codeberg. F-Droid will strip signatures during their build.
        // For Google Play, we use the same release build and bundle it with bundleRelease.
    }
    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_11
        targetCompatibility = JavaVersion.VERSION_11
    }
    kotlinOptions {
        jvmTarget = "11"
    }
    buildFeatures {
        compose = true
        buildConfig = true
    }
    
    // Packaging options for reproducible builds
    packaging {
        // Exclude version control info that AGP automatically adds
        resources {
            excludes += "META-INF/version-control-info.textproto"
            excludes += "META-INF/com.android.build/gradle-app-metadata.properties"
        }
    }
    
    // Add deterministic build information to BuildConfig for reproducible builds
    android.applicationVariants.all {
        val variant = this
        // Repository URL for source code
        variant.buildConfigField("String", "REPOSITORY_URL", "\"${repositoryUrl}\"")
        // Build type flag
        variant.buildConfigField("Boolean", "IS_DEBUG", "${variant.buildType.name == "debug"}")
    }
}

dependencies {

    implementation(libs.androidx.core.ktx)
    implementation(libs.androidx.lifecycle.runtime.ktx)
    implementation(libs.androidx.activity.compose)
    implementation(platform(libs.androidx.compose.bom))
    implementation(libs.androidx.compose.ui)
    implementation(libs.androidx.compose.ui.graphics)
    implementation(libs.androidx.compose.ui.tooling.preview)
    implementation(libs.androidx.compose.material3)
    
    // Navigation
    implementation("androidx.navigation:navigation-compose:2.7.5")
    
    // ViewModel
    implementation("androidx.lifecycle:lifecycle-viewmodel-compose:2.7.0")
    implementation("androidx.lifecycle:lifecycle-runtime-compose:2.7.0")
    
    // Preferences
    implementation("androidx.datastore:datastore-preferences:1.0.0")
    
    // JSON serialization
    implementation("org.jetbrains.kotlinx:kotlinx-serialization-json:1.6.0")
    
    // Icons
    implementation("androidx.compose.material:material-icons-extended")
    
    // WorkManager for background tasks
    implementation("androidx.work:work-runtime-ktx:2.9.0")
    
    // Markdown rendering with HTML support
    implementation(libs.markwon.core)
    implementation(libs.markwon.html)
    implementation(libs.markwon.linkify)
    
    testImplementation(libs.junit)
    androidTestImplementation(libs.androidx.junit)
    androidTestImplementation(libs.androidx.espresso.core)
    androidTestImplementation(platform(libs.androidx.compose.bom))
    androidTestImplementation(libs.androidx.compose.ui.test.junit4)
    debugImplementation(libs.androidx.compose.ui.tooling)
    debugImplementation(libs.androidx.compose.ui.test.manifest)
}
