[<img src="https://gitlab.com/IzzyOnDroid/repo/-/raw/master/assets/IzzyOnDroid.png" alt="Get it on IzzyOnDroid" width="30%">](https://apt.izzysoft.de/fdroid/index/apk/de.ntdote.medicalcalendarlog)
[<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png" alt="Get it on F-Droid" width="30%">](https://f-droid.org/packages/de.ntdote.medicalcalendarlog)

# Medical Calendar Log

A powerful Android application for tracking medical events, medications, and health metrics using your device's built-in calendar system. No additional accounts or cloud services required.

## ⚠️ Privacy Notice

Remember: the app is as privacy friendly as your calendar. Logging to Google/Samsung/Microsoft is not as private as logging to your own CalDAV instance (Nextcloud, local only, etc.)

## 🔍 Usage Examples

Here are some practical examples of how to use Medical Calendar Log for different scenarios:

### Calendar Setup
Best create a new calendar "medilog" that is available on your device. Any name will do, you can also use an existing calendar, but a calendar containing "med" or "log" will be automatically selected on first run and not clutter your "normal" calendar.

### Use Emojis
For template and drug names, use emojis. Those look nicer in the graphs and widgets, keep the layout compact and give some level of protection from people peeking at your screen.

### Example: Injection of Drug
I need to take a drug that is injected. I buy it in a pen, one full dose is 15mg and that would be dialing the pen the full 60 clicks and then injecting it. I don't need the full 15mg, but it's cheaper to buy the higher dose. So I divide the 15mg by 60 clicks, and know that one click is 0.25mg. I research the half-life of the drug and make it of variable dosage:

- Template: 💉
- Drug: 💉
- Requires Input: ✓ (enabled)
- Type: decaying
- Factor: 0.25
- Unit: mg
- Half-life: 110.0
- Reminder threshold: 96h

So when I later click the template, due to "Requires Input" being enabled, I get a popup and enter how many clicks I injected. In the main screen and graph I can observe the current and historic concentration. As it is not critical to keep above a certain threshold, but I rather looking forward to inject again, I set a reminder in hours not concentration so I can check any time when I'm supposed to inject again. 

As the drug is independently specified from the template, one could also make two Templates for the same drug, like 🍺 and 🍷, select a common drug name emoji, and add different BAC impact to each of them.

### Example: Regular Medications or General To-Dos
Just set up a template of type General, remind after 240h (10 days) and log whenever you do the task. Reminders only show up if you hit the deadline. 

### Example: Weight Tracking
- Template name: ⚖️
- Type: metric
- Unit: kg 
- Reminder: 96h

This plots your weight over time and reminds me to use the balance scale again if you keep forgetting (like I like to do). The type "metric" requires a numeric input on execution, so use "general" for chores if numeric tracking is not required.

### Editing
Use your common calendar app to correct mistakes, backup, export, share, sync, ...

## 🚀 Key Features

### Quick Event Logging
Log common medical events with a single tap using customizable template buttons. Optional dosage entry allows for precise medication tracking without hassle.

### Even Quicker Event Logging
Add 1x1 widgets to your home screen that keep you up to date on your data and allow true one-click logging. Widgets are updated hourly to conserve battery, so time displays show hours and days (not minutes), starting at "0h" for events less than an hour old. Widgets are highly customizable, can show drug concentrations, etc.

### Comprehensive Tracking
- **Health Metrics**: Monitor vital signs, symptoms, and measurements
- **Medications**: Track drug intake with automatic concentration calculations
- **General Events**: Log symptoms and health-related activities

### Real-Time Drug Concentration Monitoring
Advanced pharmacokinetic calculations provide real-time estimates of active drug concentrations in your body, helping you understand medication timing and interactions. Linear- and Half-Life decay currently supported.

### Historical Data Visualization
Interactive graphs and charts display your health data over time, making it easy to identify patterns, track progress, and share information with healthcare providers. Pan- and zoomable.

### Calendar Backend Integration
- Uses your device's native calendar system. Individual calendar recommended but not required.
- No additional accounts or subscriptions required
- Easy data export and import through standard calendar formats
- Seamless synchronization across devices using your existing calendar sync
- Edit and correct data with your well known calendar tools.
- Privacy friendly calendar strongly recommended.

### Smart Template System
Create hierarchical templates where related items contribute to common categories. For example, configure beer and wine templates to both contribute to overall alcohol tracking, enabling sophisticated health monitoring scenarios. Templates can contain multiple drugs, drugs can be in multiple templates. 

### Intelligent Reminders
Set up automated reminders for events that haven't occurred within specified timeframes:
- Medication adherence alerts
- Periodic health checks (blood pressure, weight, etc.)
- Routine medical appointments
- Custom health routines

Reminders can be muted for 1 day or until the event is logged again. Reminders also allow to directly log from the notification.

## 📱 Screenshots

![Main Screen](screenshots/main-screen.png) ![Graph View](screenshots/graph-view.png)

![Configuration Screen](screenshots/configuration-screen.png) ![Template Management](screenshots/template-management.png)

![Widget configuration](screenshots/widget-config.png)
## 🔒 Privacy & Data

Your health data can remain completely private and under your control:
- All information stored in your device's calendar
- Only transmits data to your trusted calendar backends (private calendar backend recommended)
- Easy backup through standard calendar export
- Full control over data sharing and access
- Automatically syncs with all your devices

### Required Permissions

Medical Calendar Log requires the following permissions to function:

1. **READ_CALENDAR** - Your calendar is where this app stores all logged events/medications.

2. **WRITE_CALENDAR** - Your calendar is where this app stores all logged events/medications.

3. **POST_NOTIFICATIONS** - Required to send you reminder notifications for medications, health checks, and other scheduled events you've configured.

4. **WAKE_LOCK** - Required to ensure reminder notifications are delivered on time, even when your device is in sleep mode. Also see Permission #6.

5. **RECEIVE_BOOT_COMPLETED** - Required to reschedule your reminder notifications after your device restarts, ensuring you don't miss important reminders.

6. **REQUEST_IGNORE_BATTERY_OPTIMIZATIONS** - Permission to ask the user to disable battery optimizations. Required to ensure timely notifications and current data in widgets. A lot of effort went into optimizing this app regarding battery usage, so power consumption is minimal either way.

## 📲 Building

This project uses Gradle for building. You can build the app using Android Studio or the command line:

```bash
# Set Android SDK path if needed
export ANDROID_HOME=~/Android/sdk

# For debug builds
./gradlew assembleDebug

# For release builds
./gradlew assembleRelease
```

## 🪲 Debugging
To run the hourly worker manually execute
`adb shell am broadcast -a de.ntdote.medicalcalendarlog.EVALUATE_NOTIFICATIONS -n de.ntdote.medicalcalendarlog/.service.NotificationEvaluationReceiver`
Or use the reload function in the debug card.

triggers all hourly tasks. grep for MCL to see relevant debug output.

## 🤝 Contributing

Contributions are welcome! Please feel free to submit pull requests, report bugs, or suggest new features through the issue tracker.

## 📄 License

This project is licensed under the GNU General Public License v3.0 - see the [LICENSE](LICENSE) file for details.

## 📞 Support

For questions, issues, or feature requests, please open an issue on the project repository.

## ⚠️ Medical Disclaimer

**This application is a tracking tool only and does not provide medical advice.**

- All calculations and drug concentration estimates are based on user-provided input and simplified pharmacokinetic models. These calculations **may not be accurate** and should not be used for medical decision-making.
- Scheduled reminders depend on Android system behavior and device settings. Reminders **may not always trigger** at the expected time or at all, especially if background restrictions are enabled.
- This app is **not a substitute for professional medical advice, diagnosis, or treatment**. Always consult with qualified healthcare providers regarding medications, dosages, and health decisions.
- The developers assume **no liability** for any consequences resulting from the use of this application.

**Use this app at your own risk as a supplementary tracking tool only.**
---

*Medical Calendar Log - Taking control of your health data, one event at a time.*
