package de.ntdote.medicalcalendarlog.service

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.util.Log

/**
 * Broadcast receiver for manually triggering notification evaluation via ADB
 * 
 * Usage:
 * adb shell am broadcast -a de.ntdote.medicalcalendarlog.EVALUATE_NOTIFICATIONS -n de.ntdote.medicalcalendarlog/.service.NotificationEvaluationReceiver
 */
class NotificationEvaluationReceiver : BroadcastReceiver() {
    
    override fun onReceive(context: Context, intent: Intent) {
        if (intent.action == HourlyReminderWorker.ACTION_EVALUATE_NOTIFICATIONS) {
            Log.d("NotificationEvaluationReceiver", "MCL: Received broadcast to evaluate notifications")
            HourlyReminderWorker.evaluateNotifications(context)
        }
    }
}
