package de.ntdote.medicalcalendarlog.data

import kotlinx.serialization.Serializable

/**
 * Configuration for a widget instance
 */
@Serializable
data class WidgetConfig(
    val templateId: String,
    val selectedDrugIndex: Int = 0, // Which drug to display for multi-drug templates (0-based index)
    val showTime: Boolean = true,
    val showTemplateName: Boolean = true,
    val showValue: Boolean = false,
    val showUnit: Boolean = false,
    val transparency: Int = 80, // 0-100%, where 100 = fully opaque
    val compactTime: Boolean = true, // Show time in compact format (e.g., "3d12" instead of "3d 12h")
    val nameClickQuickLog: Boolean = true, // If true, clicking name area logs directly (bypasses menu)
    val usePercentage: Boolean = false // If true, show percentage instead of raw time/concentration values (only for templates with reminders)
)
