package de.noisruker.openPasskeyAuth.utils.preferences.usecase

import de.noisruker.openPasskeyAuth.utils.preferences.IUserPreferenceRepository
import de.noisruker.openPasskeyAuth.utils.preferences.UserPreferences
import kotlinx.coroutines.flow.Flow

class StrongBoxKey(private val iUserPreferenceRepository: IUserPreferenceRepository) {
    suspend operator fun invoke(enabled: Boolean) = iUserPreferenceRepository.enableStrongBoxKeys(enabled)
}

class AskForStrongBoxKeyCreation(private val iUserPreferenceRepository: IUserPreferenceRepository) {
    suspend operator fun invoke(enabled: Boolean) = iUserPreferenceRepository.askForStrongBoxOnKeyCreation(enabled)
}

class EnableScreenshots(private val iUserPreferenceRepository: IUserPreferenceRepository) {
    suspend operator fun invoke(enabled: Boolean) = iUserPreferenceRepository.enableScreenshots(enabled)
}

class AllowKeyboard(private val iUserPreferenceRepository: IUserPreferenceRepository) {
    suspend operator fun invoke(enabled: Boolean) = iUserPreferenceRepository.allowKeyboard(enabled)
}

class EnableScramblePinLayout(private val iUserPreferenceRepository: IUserPreferenceRepository) {
    suspend operator fun invoke(enabled: Boolean) = iUserPreferenceRepository.enableScramblePinLayout(enabled)
}

class GetSettings(private val iUserPreferenceRepository: IUserPreferenceRepository) {
    operator fun invoke(): Flow<UserPreferences> = iUserPreferenceRepository.userPreferences
}

class EnableAppLock(private val iUserPreferenceRepository: IUserPreferenceRepository) {
    suspend operator fun invoke(enabled: Boolean) = iUserPreferenceRepository.enableScreenLock(enabled)
}

class AppUnlockSecret(private val iUserPreferenceRepository: IUserPreferenceRepository) {
    suspend operator fun invoke(secret: String) = iUserPreferenceRepository.setAppUnlockSecret(secret)
}