package de.noisruker.openPasskeyAuth.utils.preferences

import kotlinx.coroutines.flow.Flow

interface IUserPreferenceRepository {
    val userPreferences: Flow<UserPreferences>

    suspend fun enableScramblePinLayout(enabled: Boolean)

    suspend fun enableScreenshots(enabled: Boolean)

    suspend fun allowKeyboard(enabled: Boolean)

    suspend fun enableStrongBoxKeys(enabled: Boolean)

    suspend fun askForStrongBoxOnKeyCreation(enabled: Boolean)

    suspend fun enableScreenLock(enabled: Boolean)

    suspend fun setAppUnlockSecret(secret: String)

    suspend fun appUnlockIV(iv: String)
}