package de.noisruker.openPasskeyAuth.utils.hwkeys

import com.google.android.gms.fido.fido2.api.common.UserVerificationRequirement
import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.Json
import kotlinx.serialization.json.JsonNames

fun String.parseGetCredentialRequest(json: Json): GetCredentialRequestData? {
    return runCatching { json.decodeFromString<GetCredentialRequestData>(this) }.getOrNull()
}

@Serializable
data class GetCredentialRequestData(
    val challenge: String,
    val rpId: String,
    val allowCredentials: List<AllowCredential> = listOf(),
    val userVerification: UserVerification = UserVerification.PREFERRED,
)

@Serializable
data class AllowCredential(
    val id: String,
    val transports: List<Transport>,
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
enum class Transport(val value: String) {
    @JsonNames("bt")
    BLUETOOTH("bt"),
    @JsonNames("ble")
    BLUETOOTH_LOW_ENERGY("ble"),
    @JsonNames("nfc")
    NFC("nfc"),
    @JsonNames("usb")
    USB("usb"),
    @JsonNames("internal")
    INTERNAL("internal"),
    @JsonNames("hybrid", "cable")
    HYBRID("hybrid"),
}

@OptIn(ExperimentalSerializationApi::class)
@Serializable
enum class UserVerification {
    @JsonNames("preferred")
    PREFERRED,
    @JsonNames("required")
    REQUIRED,
    @JsonNames("discouraged")
    DISCOURAGED;

    fun asMicrogVerification(): UserVerificationRequirement {
        return when(this) {
            UserVerification.PREFERRED -> UserVerificationRequirement.PREFERRED
            UserVerification.REQUIRED -> UserVerificationRequirement.REQUIRED
            UserVerification.DISCOURAGED -> UserVerificationRequirement.DISCOURAGED
        }
    }
}