package de.noisruker.openPasskeyAuth.utils.hwkeys

import kotlinx.serialization.Serializable
import kotlinx.serialization.json.Json

fun String.parseCreateCredentialRequest(json: Json): CreateCredentialRequest? {
    return json.decodeFromString<CreateCredentialRequest>(this)
}

@Serializable
data class CreateCredentialRequest(
    val authenticatorSelection: AuthenticatorSelection,
    val attestation: String,
    val challenge: String,
    val pubKeyCredParam: List<PubKeyCredParam> = listOf(),
    val rp: Rp,
    val user: User,
    val extensions: Extensions? = null,
)

@Serializable
data class AuthenticatorSelection(
    val residentKey: String? = null,
    val userVerification: String? = null,
    val requireResidentKey: Boolean? = null,
)

@Serializable
data class PubKeyCredParam(
    val alg: Int,
    val type: String,
)

@Serializable
data class Rp(
    val id: String,
    val name: String,
)

@Serializable
data class User(
    val displayName: String,
    val id: String,
    val name: String,
)

@Serializable
data class Extensions(
    val credProps: Boolean? = null,
    val appId: String? = null,
)