package de.noisruker.openPasskeyAuth.utils

import android.content.Context
import android.content.pm.PackageManager
import android.security.keystore.KeyGenParameterSpec
import android.security.keystore.KeyProperties
import android.security.keystore.StrongBoxUnavailableException
import android.util.Log
import de.noisruker.openPasskeyAuth.R
import java.security.KeyPairGenerator
import java.security.MessageDigest
import java.security.spec.ECGenParameterSpec
import javax.crypto.spec.IvParameterSpec
import kotlin.io.encoding.ExperimentalEncodingApi

object OpenPasskeyAuthUtils {

    fun appInfoToOrigin(context: Context, info: androidx.credentials.provider.CallingAppInfo): String {

//        Log.d("CredmanUtils","!!!+++ PackageName:"+info.packageName );

        // https://www.gstatic.com/gpm-passkeys-privileged-apps/apps.json .)
        val privilegedAllowlist = context.resources.openRawResource(R.raw.allowlist).bufferedReader().use {it.readText()}

        val cert = info.signingInfo.apkContentsSigners[0].toByteArray()
        val md = MessageDigest.getInstance("SHA-256")
        val certHash = md.digest(cert)
        Log.d("OPA","!!!+++ apkhash +++!!!: ${b64Encode(certHash)}"  )

        // This is the format for origin
        var origin: String
        try{
            origin = info.getOrigin(privilegedAllowlist)!! // go to the catch clause when null
        }catch(e:Exception ){
            Log.e("CredmanUtils",e.toString()  )
            origin="android:apk-key-hash:${b64Encode(certHash)}"
        }
        Log.d("OPA","!!!+++ origin +++!!!: $origin"  )


        return origin
    }

    @OptIn(ExperimentalEncodingApi::class)
    fun b64Encode(data:ByteArray):String{
        // replace with import androidx.credentials.webauthn.WebAuthnUtils in future
        return android.util.Base64.encodeToString(
            data,
            android.util.Base64.NO_PADDING or android.util.Base64.NO_WRAP or android.util.Base64.URL_SAFE
        )
    }

    @OptIn(ExperimentalEncodingApi::class)
    fun b64Decode(data:String?):ByteArray?{
        // replace with import androidx.credentials.webauthn.WebAuthnUtils in future
        if(data.isNullOrEmpty()) return null
        return android.util.Base64.decode(
            data,
            android.util.Base64.NO_PADDING or android.util.Base64.NO_WRAP or android.util.Base64.URL_SAFE
        )
    }

    fun validateRpId(context: Context, info: androidx.credentials.provider.CallingAppInfo, rpid: String): String{
        var origin = appInfoToOrigin(context, info)
        Log.d("OPA","!!!+++ rpid: $rpid")
        val rpIdForRexEx = rpid.replace(".","""\.""")
        if (Regex("^https://([A-Za-z0-9\\-.]*\\.)?$rpIdForRexEx($|/.*)").matches(origin)){
            //take out  "https://" and trailing slash "/" to make origin a pure domain.
            origin = rpid
        }
        return origin
    }

    fun checkStrongBoxAvailability(context: Context): Boolean {
        if (!context.packageManager.hasSystemFeature(PackageManager.FEATURE_STRONGBOX_KEYSTORE)) return false

        val spec = KeyGenParameterSpec.Builder(
            "opa-key",
            KeyProperties.PURPOSE_SIGN
        ).run {
            setDigests(KeyProperties.DIGEST_SHA256)
            setAlgorithmParameterSpec(ECGenParameterSpec("secp256r1"))
            setIsStrongBoxBacked(true)
            build()
        }
        val keyPairGen = KeyPairGenerator.getInstance("EC", "AndroidKeyStore")

        try {
            keyPairGen.initialize(spec)
        } catch (exception: StrongBoxUnavailableException) {
            return false
        }
        return true
    }

    fun getIV(iv: String): IvParameterSpec {
        return IvParameterSpec(b64Decode(iv))
    }

}