package de.noisruker.openPasskeyAuth.utils

import android.annotation.SuppressLint
import android.util.Base64
import androidx.credentials.webauthn.AuthenticatorResponse
import org.json.JSONObject

@SuppressLint("RestrictedApi")
class HardwareKeyAuthenticationResponse(private val clientData: ByteArray, private val userHandle: ByteArray?, private val authenticatorData: ByteArray, private val signature: ByteArray, override var clientJson: JSONObject = JSONObject()) : AuthenticatorResponse {

    private fun b64Encode(data: ByteArray): String {
        return Base64.encodeToString(
            data,
            Base64.NO_PADDING or Base64.NO_WRAP or Base64.URL_SAFE
        )
    }

    override fun json(): JSONObject {
        clientJson.put("clientDataJSON", b64Encode(clientData))
        clientJson.put("authenticatorData", b64Encode(authenticatorData))
        clientJson.put("signature", b64Encode(signature))

        if (userHandle != null) clientJson.put("userHandle", b64Encode(userHandle))

        return clientJson
    }
}