package de.noisruker.openPasskeyAuth.utils

import android.annotation.SuppressLint
import androidx.credentials.webauthn.AuthenticatorAssertionResponse
import androidx.credentials.webauthn.AuthenticatorResponse
import org.json.JSONObject

@SuppressLint("RestrictedApi")
class DeviceKeyAuthenticationResponse(
    private val baseResponse: AuthenticatorAssertionResponse, private val clientDataJSON: String
): AuthenticatorResponse {
    override var clientJson: JSONObject = baseResponse.clientJson

    override fun json(): JSONObject {
        val response = baseResponse.json()
        response.put("clientDataJSON", clientDataJSON)
        return response
    }

}