package de.noisruker.openPasskeyAuth.ui.settings

import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import androidx.lifecycle.viewModelScope
import de.noisruker.openPasskeyAuth.utils.preferences.usecase.AllowKeyboard
import de.noisruker.openPasskeyAuth.utils.preferences.usecase.AskForStrongBoxKeyCreation
import de.noisruker.openPasskeyAuth.utils.preferences.usecase.EnableAppLock
import de.noisruker.openPasskeyAuth.utils.preferences.usecase.EnableScramblePinLayout
import de.noisruker.openPasskeyAuth.utils.preferences.usecase.EnableScreenshots
import de.noisruker.openPasskeyAuth.utils.preferences.usecase.StrongBoxKey
import de.noisruker.openPasskeyAuth.utils.preferences.usecase.GetSettings
import kotlinx.coroutines.flow.SharingStarted
import kotlinx.coroutines.flow.stateIn
import kotlinx.coroutines.launch

class SettingsViewModel(
    private val strongBoxKey: StrongBoxKey,
    private val askForStrongBoxKeyCreation: AskForStrongBoxKeyCreation,
    private val allowKeyboard: AllowKeyboard,
    private val enableScreenshots: EnableScreenshots,
    private val enableScramblePinLayout: EnableScramblePinLayout,
    private val appLock: EnableAppLock,
    getSettings: GetSettings,
) : ViewModel() {
    val userPreferences = getSettings()
        .stateIn(
            scope = viewModelScope,
            SharingStarted.Eagerly,
            null
        )

    fun updateStrongBoxKey(enable: Boolean) {
        viewModelScope.launch {
            strongBoxKey(enable)
        }
    }

    fun updateAllowKeyboard(enable: Boolean) {
        viewModelScope.launch {
            allowKeyboard(enable)
        }
    }

    fun updateEnableScreenshots(enable: Boolean) {
        viewModelScope.launch {
            enableScreenshots(enable)
        }
    }

    fun updateScramblePinLayout(enable: Boolean) {
        viewModelScope.launch {
            enableScramblePinLayout(enable)
        }
    }

    fun updateAppLock(enable: Boolean) {
        viewModelScope.launch {
            appLock(enable)
        }
    }

    fun updateAskForStrongBoxKeyCreation(enable: Boolean) {
        viewModelScope.launch {
            askForStrongBoxKeyCreation(enable)
        }
    }

    class Factory(
        private val strongBoxKey: StrongBoxKey,
        private val askForStrongBoxKeyCreation: AskForStrongBoxKeyCreation,
        private val allowKeyboard: AllowKeyboard,
        private val enableScreenshots: EnableScreenshots,
        private val enableScramblePinLayout: EnableScramblePinLayout,
        private val appLock: EnableAppLock,
        private val getSettings: GetSettings,
        ) : ViewModelProvider.Factory {
        override fun <T : ViewModel> create(modelClass: Class<T>): T {
            if (modelClass.isAssignableFrom(SettingsViewModel::class.java)) {
                @Suppress("UNCHECKED_CAST")
                return SettingsViewModel(
                    strongBoxKey,
                    askForStrongBoxKeyCreation,
                    allowKeyboard,
                    enableScreenshots,
                    enableScramblePinLayout,
                    appLock,
                    getSettings,
                ) as T
            }
            error("Unknown ViewModel class: $modelClass")
        }
    }
}