package de.noisruker.openPasskeyAuth.ui

import android.app.Activity
import android.content.Intent
import android.os.Build
import android.provider.Settings
import androidx.activity.compose.setContent
import androidx.annotation.RequiresApi
import androidx.annotation.StringRes
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.automirrored.filled.ArrowBack
import androidx.compose.material.icons.automirrored.filled.ArrowForward
import androidx.compose.material.icons.outlined.Lock
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.HorizontalDivider
import androidx.compose.material3.Icon
import androidx.compose.material3.IconButton
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Scaffold
import androidx.compose.material3.Text
import androidx.compose.material3.TopAppBar
import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.unit.dp
import de.noisruker.openPasskeyAuth.ui.theme.OpenPasskeyAuthTheme
import androidx.core.net.toUri
import de.noisruker.openPasskeyAuth.Locator
import de.noisruker.openPasskeyAuth.R
import de.noisruker.openPasskeyAuth.ui.settings.SettingsActivity
import de.noisruker.openPasskeyAuth.utils.preferences.UserPreferences


class InfoActivity : BaseActivity() {
    @RequiresApi(Build.VERSION_CODES.VANILLA_ICE_CREAM)
    @OptIn(ExperimentalMaterial3Api::class)
    override fun onResume() {
        super.onResume()

        setContent {
            OpenPasskeyAuthTheme {
                Scaffold(
                    topBar = {
                        TopAppBar(
                            title = {
                                Text(text = stringResource(R.string.info_activity_name))
                            },
                            navigationIcon = {
                                IconButton(onClick = {
                                    finish()
                                }) {
                                    Icon(
                                        Icons.AutoMirrored.Filled.ArrowBack,
                                        contentDescription = "Back"
                                    )
                                }
                            },
                            actions = {
                                val preferences by Locator.userPreferencesRepository.userPreferences.collectAsState(
                                    UserPreferences()
                                )
                                if (preferences.appLock) {
                                    IconButton(onClick = {
                                        super.lockApp()
                                        recreate()
                                    }) {
                                        Icon(
                                            Icons.Outlined.Lock,
                                            contentDescription = stringResource(R.string.lock)
                                        )
                                    }
                                }
                            }
                        )
                    }
                ) { padding ->
                    LazyColumn(
                        modifier = Modifier.padding(padding)
                    ) {
                        item {
                            SettingsActivity.SettingsGroup {
                                Column(
                                    modifier = Modifier.fillMaxWidth().padding(16.dp),
                                ) {
                                    Text(
                                        text = stringResource(R.string.app_information),
                                        style = MaterialTheme.typography.bodyLarge
                                    )
                                }
                            }
                        }

                        item {
                            SettingsActivity.SettingsGroup(stringResource(R.string.setup)) {
                                SetupOPA(this@InfoActivity)
                            }
                        }

                        item {
                            SettingsActivity.SettingsGroup(stringResource(R.string.source_code)) {
                                Column(
                                    modifier = Modifier.fillMaxWidth().padding(16.dp),
                                ) {
                                    Text(
                                        text = stringResource(R.string.source_code_description),
                                        style = MaterialTheme.typography.bodyLarge
                                    )
                                }

                                HorizontalDivider()

                                InfoLinkItem(Modifier, {
                                    val browserIntent =
                                        Intent(Intent.ACTION_VIEW, "https://git.noisruker.de/Juhu1705/open-android-authenticator".toUri())
                                    startActivity(browserIntent)
                                }, R.string.title_activity_main, R.string.this_apps_source_code)

                                HorizontalDivider()

                                InfoLinkItem(Modifier, {
                                    val browserIntent =
                                        Intent(Intent.ACTION_VIEW, "https://github.com/juhu1705/GmsCore".toUri())
                                    startActivity(browserIntent)
                                }, R.string.microg_gms_core, R.string.microg_gms_core_description_forked)
                            }
                        }

                        item {
                            SettingsActivity.SettingsGroup(stringResource(R.string.license)) {
                                InfoLinkItem(Modifier, {
                                    val browserIntent =
                                        Intent(Intent.ACTION_VIEW, "https://git.noisruker.de/Juhu1705/open-android-authenticator/raw/branch/main/LICENSE".toUri())
                                    startActivity(browserIntent)
                                }, R.string.license_name, R.string.license_description)
                            }
                        }

                        item {
                            SettingsActivity.SettingsGroup(stringResource(R.string.used_projects)) {
                                Column(
                                    modifier = Modifier.fillMaxWidth().padding(16.dp),
                                ) {
                                    Text(
                                        text = stringResource(R.string.used_projects_description),
                                        style = MaterialTheme.typography.bodyLarge
                                    )
                                }

                                HorizontalDivider()

                                InfoLinkItem(Modifier, {
                                    val browserIntent =
                                        Intent(Intent.ACTION_VIEW, "https://github.com/microg/GmsCore".toUri())
                                    startActivity(browserIntent)
                                }, R.string.microg_gms_core, R.string.microg_gms_core_description)

                                HorizontalDivider()

                                InfoLinkItem(Modifier, {
                                    val browserIntent =
                                        Intent(Intent.ACTION_VIEW, "https://github.com/ko-koiwai/MyCredentialManager".toUri())
                                    startActivity(browserIntent)
                                },
                                    R.string.my_credential_manager,
                                    R.string.my_credential_manager_description
                                )

                                HorizontalDivider()

                                InfoLinkItem(Modifier, {
                                    val browserIntent =
                                        Intent(Intent.ACTION_VIEW, "https://codeberg.org/s1m/hw-fido2-provider".toUri())
                                    startActivity(browserIntent)
                                },
                                    R.string.hw_fido2_provider,
                                    R.string.hw_fido2_provider_description
                                )
                            }
                        }
                    }
                }
            }
        }
    }

    @Composable
    fun SetupOPA(activity: Activity) {
        Column(modifier = Modifier.fillMaxWidth().padding(16.dp)) {
            Text(
                text = stringResource(R.string.setup_steps),
                style = MaterialTheme.typography.bodyLarge
            )
        }

        HorizontalDivider()

        InfoLinkItem(Modifier, {
            activity.startActivity(Intent(Settings.ACTION_SETTINGS))
        }, R.string.setup, R.string.setup_credman)
    }

    @Composable
    private fun InfoLinkItem(
        modifier: Modifier = Modifier,
        onClicked: () -> Unit,
        @StringRes title: Int,
        @StringRes description: Int,
    ) {
        Row(
            modifier = modifier.fillMaxWidth().clickable {
                onClicked()
            },
            verticalAlignment = Alignment.CenterVertically
        ) {
            Row(
                modifier = modifier
                    .padding(horizontal = 16.dp, vertical = 8.dp),
                verticalAlignment = Alignment.CenterVertically
            ) {
                Column(
                    modifier = Modifier.weight(1.0f),
                    verticalArrangement = Arrangement.spacedBy(8.dp)
                ) {
                    Text(
                        text = stringResource(id = title),
                        style = MaterialTheme.typography.titleSmall,
                        maxLines = 1,
                        color = MaterialTheme.colorScheme.primary
                    )
                    Text(
                        text = stringResource(id = description),
                        style = MaterialTheme.typography.labelMedium,
                        color = MaterialTheme.colorScheme.primary
                    )
                }

                IconButton(onClick = {
                    onClicked()
                }) {
                    Icon(
                        Icons.AutoMirrored.Default.ArrowForward,
                        contentDescription = stringResource(R.string.delete),
                        tint = MaterialTheme.colorScheme.primary
                    )
                }
            }
        }
    }

}