package de.noisruker.openPasskeyAuth

import android.os.CancellationSignal
import android.os.OutcomeReceiver
import androidx.core.content.edit
import androidx.credentials.exceptions.ClearCredentialException
import androidx.credentials.exceptions.CreateCredentialException
import androidx.credentials.exceptions.CreateCredentialUnknownException
import androidx.credentials.exceptions.GetCredentialException
import androidx.credentials.exceptions.GetCredentialUnknownException
import androidx.credentials.provider.BeginCreateCredentialRequest
import androidx.credentials.provider.BeginCreateCredentialResponse
import androidx.credentials.provider.BeginGetCredentialRequest
import androidx.credentials.provider.BeginGetCredentialResponse
import androidx.credentials.provider.CredentialProviderService
import androidx.credentials.provider.ProviderClearCredentialStateRequest

class OpenPasskeyAuthService : CredentialProviderService() {

    override fun onCreate() {
        super.onCreate()

        getSharedPreferences("org.microg.gms_connection", MODE_PRIVATE).edit { putString("target", packageName) }
    }

    companion object {
        // These intent actions are specified for corresponding activities
        // that are to be invoked through the PendingIntent(s)
        const val GET_PASSKEY_INTENT_ACTION = "de.noisruker.openPasskeyAuth.action.GET_PASSKEY"
        const val CREATE_PASSKEY_INTENT_ACTION = "de.noisruker.openPasskeyAuth.action.CREATE_PASSKEY"
        const val CREDENTIAL_DATA_EXTRA = "de.noisruker.openPasskeyAuth.CREDENTIAL_DATA"
        const val UNLOCK_APP_INTENT_ACTION = "de.noisruker.openPasskeyAuth.action.UNLOCK_APP"
        const val CREDENTIAL_ID = "credentialId"
        const val ACCOUNT_ID = "accountId"
        const val DEVICE_ACCOUNT = "DEVICE_ACCOUNT_ID"
        const val HARDWARE_KEY_ACCOUNT = "HARDWARE_KEY_ACCOUNT_ID"
    }

    override fun onBeginCreateCredentialRequest(
        request: BeginCreateCredentialRequest,
        cancellationSignal: CancellationSignal,
        callback: OutcomeReceiver<BeginCreateCredentialResponse, CreateCredentialException>
    ) {
        val response: BeginCreateCredentialResponse? = OpenPasskeyAuthServiceUtils.processCreateCredentialRequest(this.application, request)
        if (response != null) {
            callback.onResult(response)
        } else {
            callback.onError(CreateCredentialUnknownException())
        }
    }

    override fun onBeginGetCredentialRequest(
        request: BeginGetCredentialRequest,
        cancellationSignal: CancellationSignal,
        callback: OutcomeReceiver<BeginGetCredentialResponse, GetCredentialException>
    ) {
        try {
            callback.onResult(OpenPasskeyAuthServiceUtils.processGetCredentialRequest(this.application, this, request))
        } catch (_: GetCredentialException) {
            callback.onError(GetCredentialUnknownException())
        }
    }

    override fun onClearCredentialStateRequest(
        request: ProviderClearCredentialStateRequest,
        cancellationSignal: CancellationSignal,
        callback: OutcomeReceiver<Void?, ClearCredentialException>
    ) {
        // As no affected state should be stored this is not needed I think!
    }





}