# My Open Passkey Authentication App (OPA)

Credential provider App that allows the use of USB/NFC security key as well as device backed fido-keys for passkey/fido2/u2f authentication.

I wanted to have an App replacing Google Plays Authenticator and 
that is working well with my password manager keypass while allowing me to use on device 
and hardware FiDO2 Keys to authenticate to services.

To provide this I found to other projects that had done most of the stuff needed 
and modified them so they could provide what I wanted.
So thanks to [hwsecurity](https://github.com/hwsecurity-sdk/hwsecurity/tree/master) (licenced under GPLv3) now replaced by the local FiDo implementation of [GMSCore](https://github.com/microg/GmsCore) and 
the [implementation of googles credential manager example](https://github.com/ko-koiwai/MyCredentialManager) (licenced under MIT)
by Junzi Zhang (@junzi-zhang), Rikuto Ohike (@xri-ooike), Kosuke Koiwai (@ko-koiwai)

## Download

[<img src="https://f-droid.org/badge/get-it-on.png"
alt="Get it on F-Droid"
height="80">](https://f-droid.org/packages/de.noisruker.openPasskeyAuth)


This project is published on [F-Droid](https://f-droid.org/packages/de.noisruker.openPasskeyAuth) or you can get it directly from the [releases](https://git.noisruker.de/Juhu1705/open-passkey-authenticator/releases) and I plan to publish it on [Accrescent](https://accrescent.app/) when Accrescent is out of beta.

To verify the APK, use the following certificate fingerprints:

```
SHA-256 digest: ec21f2c6f9d0f887e7545b5b8b089a1aa9fdbc71b8e66b8b5e75de639e84cec1
SHA-1 digest: a2780588425dd0ad1243c66ee2be205bbba00d49
```

As the Credential Provider API is only implemented for Android 14 and higher devices below Android 14 are not supported.

You need to setup this project as Credential Provider under Password, passkeys & accounts in your Android settings.
Then you are able to create and use on device passkeys as well as use hardware passkeys for authentication 
in your Webbrowser or other Android apps using the credential manager API.

## Building

You can build this app using android studio.
As I have modified the GMSCore dependency it is integrated using https://jitpack.io.

## Technical Details

This app exposes a [CredentialProviderService](https://developer.android.com/reference/androidx/credentials/provider/CredentialProviderService) that can be used to try login with a hardware/device security key.
For simplicity I integrated [microG](https://github.com/microg/GmsCore/wiki)s implementation of the fido2 service for hardware key support.
Therefore you will find `com.google.gms` classes in the apk originating from microGs implementation of the google services.
