#!/bin/bash

latest_tag=$(curl "https://codeberg.org/api/v1/repos/mondstern/AndroidAcrylicIconPack/tags?page=1&limit=1" | jq -r '.[].name')

if [ -z "${latest_tag}" ]; then
  echo "Something went really wrong: couldn't find the latest tag."
  exit 1
fi

highestVersionCode=$(curl "https://codeberg.org/mondstern/AndroidAcrylicIconPack/raw/tag/${latest_tag}/app/build.gradle" | sed -n 's/\s*versionCode\s=\?\s\?\(.*\)/\1/p')

versionCode=$(sed -n 's/\s*versionCode =\?\s\?\(.*\)/\1/p' app/build.gradle.kts)

if [ "${versionCode}" -le "${highestVersionCode}" ]; then
  echo "Current version code is not higher than the highest tag (current: ${versionCode}, highest: ${highestVersionCode}). Make sure to increase versionCode in app/build.gradle."
  exit 1
fi

versionName=$(sed -n 's/\s*versionName =\?\s\?"\(.*\)"/\1/p' app/build.gradle.kts)

if [ "${versionCode}.0" != "${versionName}" ]; then
  echo "Expected versionName to be ${versionCode}.0 but found ${versionName}."
  exit 1
fi
