# Privacy Policy

This policy explains what data we collect, how we use it, and the measures we take to protect it.

## 1. Data Collection

Kvaesitso collects and processes data to deliver essential features and improve your experience.
Unless otherwise specified, all data is stored locally on your device and is inaccessible to other
apps or users.

#### **Data Collected by Kvaesitso**

- **Installed apps:** Names of apps installed on your device.
- **App usage:** Frequency of app launches.
- **Location:** Your current location for weather forecasts (only if you enable automatic location
  and grant location permissions).
- **Searchable data:**
    - **Apps and shortcuts**: Data for indexing installed apps and shortcuts.
    - **Calendar events**: Title, time, location, attendees, and description.
    - **Contacts**: Name, phone numbers, email addresses, and photos.
    - **Local files:** File names, paths, sizes, types, metadata (e.g., EXIF, ID3 tags), and
      thumbnails.
    - **Cloud files:** Metadata for supported cloud services (e.g., file name, size, owner).
- **Media playback metadata:** Details about currently playing media.
- **Crash and error reports:** Debugging information to identify and resolve issues.
- **Connected accounts:** Credentials for authorized third-party integrations (e.g., Nextcloud,
  Owncloud).

## 2. How We Use Your Data

- **Local Data Use:** All data is processed locally to enable features such as search, app usage
  tracking, and weather updates.
- **Crash Reporting:** Crash data is used to debug and improve the app. Reports are stored locally
  and shared only if you choose to do so.
- **Search Functionality:** Search results are generated locally. For third-party services, search
  queries may be sent to their servers (e.g., weather providers, Wikipedia).

## 3. Data Protection

We take measures to ensure your data is secure:

- **Local Storage:** All data is stored on your device in a secure, app-specific directory that
  cannot be accessed by other apps.
- **Your Control:** You can delete all app data at any time by uninstalling the app or clearing its
  storage.

## 4. Built-In Integrations

Kvaesitso includes built-in integrations that may connect to external services. These are optional
and can be enabled or disabled in the app settings.

### Weather Providers

Kvaesitso integrates with several weather providers:

- **OpenWeatherMap, MET Norway, HERE, Bright Sky (Deutscher Wetterdienst):** Location data (current
  or manually set) is transmitted periodically to these services to provide accurate weather
  forecasts.
- Each provider’s privacy policy applies.

### Wikipedia

When enabled, search queries are sent to Wikipedia servers to display search results. Wikipedia’s
privacy policy applies.

## 5. Plugins

Kvaesitso supports plugins that extend the app's functionality. These plugins can be first-party (
developed by Kvaesitso developers) or third-party (developed by external developers). Plugins are
optional and can be enabled or disabled in the app settings.

### Data Shared with Plugins

When you enable a plugin, the following data may be shared with it, depending on the plugin’s
functionality:

- **Search Queries:** The search queries you enter into the app’s search bar may be shared with
  plugins
  to generate results.
- **Location Data:** If a plugin requires location information (such as a weather or places search
  plugin), your current location may be shared with that plugin (only if you have granted location
  permissions).

### Data Stored by Kvaesitso

Kvaesitso may store copies of the data it receives from plugins locally in its own local storage
directory. This data is used to enhance performance and provide offline access.

### Plugin Policies

For more detailed information on how data is handled by specific first-party plugins, please refer
to **Appendix A: Plugin Policies**.

For third-party plugins, please consult the respective plugin's privacy policy for additional
details on data usage and protection.

## 6. Crash Reports

Crash reports are stored locally and never shared automatically. They include:

- Technical details about the crash.
- Device information (e.g., model, operating system).

You can share crash reports manually (e.g., via GitHub). Note that shared reports may become public
and subject to the **GitHub Privacy Policy**.

## 7. Your Rights and Control

- **Data Access:** All data resides on your device, ensuring you retain full control.
- **Data Deletion:** Uninstalling the app or clearing its data removes all stored information.
- **Opt-Out:** Optional integrations and plugins can be enabled or disabled at any time.

## Appendix A: Plugin Policies

### Google Apps Plugin

The Google Plugin enables integrations with Google Drive, Calendar, and Tasks.

#### Data Accessed by the Plugin

- **General Google Account Information:** Account name, email address.
- **Google Drive:** File metadata (e.g., names, types, sizes, owners).
- **Google Calendar:** Event details (e.g., title, time, location, attendees, description).
- **Google Tasks:** Task lists, due dates, and notes.

#### How the Data is Used

The data accessed by the plugin is used to provide search results from your Google Drive, Calendar,
and Tasks within the Kvaesitso app. This allows you to quickly search for and access your files,
events, and tasks directly from the app. Kvaesitso may store copies of this data locally, in
accordance with its own privacy policy. The plugin may also cache data locally for performance
reasons.

#### How the Data is Protected

All data and credentials are stored securely on your device and in an isolated storage directory
inaccessible to other apps or users. HTTPS is used to encrypt data transmitted between the app and
Google services. You can always delete local data by clearing the plugin’s data or uninstalling
the plugin.

#### Data Shared with Third Parties

Search queries may be sent to Google servers if online results are enabled. Google’s Privacy Policy
applies.
