package de.mm20.launcher2.themes.typography

val DefaultTextStyles = TextStyles(
    displayLarge = TextStyle(
        fontFamily = "brand",
        fontSize = 57,
        fontWeight = FontWeight.Absolute(500),
        lineHeight = 64,
        letterSpacing = -0.25f
    ),
    displayMedium = TextStyle(
        fontFamily = "brand",
        fontSize = 45,
        fontWeight = FontWeight.Absolute(500),
        lineHeight = 52,
        letterSpacing = 0f
    ),
    displaySmall = TextStyle(
        fontFamily = "brand",
        fontSize = 36,
        fontWeight = FontWeight.Absolute(500),
        lineHeight = 44,
        letterSpacing = 0f
    ),
    headlineLarge = TextStyle(
        fontFamily = "brand",
        fontSize = 32,
        fontWeight = FontWeight.Absolute(600),
        lineHeight = 40,
        letterSpacing = 0f
    ),
    headlineMedium = TextStyle(
        fontFamily = "brand",
        fontSize = 28,
        fontWeight = FontWeight.Absolute(600),
        lineHeight = 36,
        letterSpacing = 0f
    ),
    headlineSmall = TextStyle(
        fontFamily = "brand",
        fontSize = 24,
        fontWeight = FontWeight.Absolute(600),
        lineHeight = 32,
        letterSpacing = 0f
    ),
    titleLarge = TextStyle(
        fontFamily = "brand",
        fontSize = 22,
        fontWeight = FontWeight.Absolute(600),
        lineHeight = 28,
        letterSpacing = 0f
    ),
    titleMedium = TextStyle(
        fontFamily = "brand",
        fontSize = 16,
        fontWeight = FontWeight.Absolute(600),
        lineHeight = 24,
        letterSpacing = 0.15f
    ),
    titleSmall = TextStyle(
        fontFamily = "brand",
        fontSize = 14,
        fontWeight = FontWeight.Absolute(600),
        lineHeight = 20,
        letterSpacing = 0.1f
    ),
    bodyLarge = TextStyle(
        fontFamily = "plain",
        fontSize = 16,
        fontWeight = FontWeight.Absolute(400),
        lineHeight = 24,
        letterSpacing = 0.5f
    ),
    bodyMedium = TextStyle(
        fontFamily = "plain",
        fontSize = 14,
        fontWeight = FontWeight.Absolute(400),
        lineHeight = 20,
        letterSpacing = 0.25f
    ),
    bodySmall = TextStyle(
        fontFamily = "plain",
        fontSize = 12,
        fontWeight = FontWeight.Absolute(400),
        lineHeight = 16,
        letterSpacing = 0.4f
    ),
    labelLarge = TextStyle(
        fontFamily = "brand",
        fontSize = 14,
        fontWeight = FontWeight.Absolute(500),
        lineHeight = 20,
        letterSpacing = 0.1f
    ),
    labelMedium = TextStyle(
        fontFamily = "brand",
        fontSize = 12,
        fontWeight = FontWeight.Absolute(500),
        lineHeight = 16,
        letterSpacing = 0.5f
    ),
    labelSmall = TextStyle(
        fontFamily = "brand",
        fontSize = 11,
        fontWeight = FontWeight.Absolute(500),
        lineHeight = 16,
        letterSpacing = 0.5f
    )
)

val DefaultEmphasizedTextStyles = TextStyles(
    displayLarge = TextStyle(fontWeight = FontWeight.Relative(100)),
    displayMedium = TextStyle(fontWeight = FontWeight.Relative(100)),
    displaySmall = TextStyle(fontWeight = FontWeight.Relative(100)),
    headlineLarge = TextStyle(fontWeight = FontWeight.Relative(100)),
    headlineMedium = TextStyle(fontWeight = FontWeight.Relative(100)),
    headlineSmall = TextStyle(fontWeight = FontWeight.Relative(100)),
    titleLarge = TextStyle(fontWeight = FontWeight.Relative(100)),
    titleMedium = TextStyle(fontWeight = FontWeight.Relative(100)),
    titleSmall = TextStyle(fontWeight = FontWeight.Relative(100)),
    bodyLarge = TextStyle(fontWeight = FontWeight.Relative(100)),
    bodyMedium = TextStyle(fontWeight = FontWeight.Relative(100)),
    bodySmall = TextStyle(fontWeight = FontWeight.Relative(100)),
    labelLarge = TextStyle(fontWeight = FontWeight.Relative(200)),
    labelMedium = TextStyle(fontWeight = FontWeight.Relative(200)),
    labelSmall = TextStyle(fontWeight = FontWeight.Relative(200))
)