package de.mm20.launcher2.ui.component.weather

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.PathBuilder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp


private fun weatherIcon(
    name: String,
    path: PathBuilder.() -> Unit,
): ImageVector {
    return ImageVector.Builder(
        name = name,
        defaultHeight = 24.dp,
        defaultWidth = 24.dp,
        viewportWidth = 24f,
        viewportHeight = 24f,
    ).apply {
        path(
            fill = SolidColor(Color.Black),
            fillAlpha = 1f,
            stroke = null,
            strokeAlpha = 1f,
            strokeLineWidth = 1f,
            strokeLineCap = StrokeCap.Butt,
            strokeLineJoin = StrokeJoin.Bevel,
            strokeLineMiter = 1f,
            pathBuilder = path
        )
    }.build()
}

val WeatherCloud = weatherIcon("WeatherCloud") {
    moveTo(15.240234f, 6.953125f)
    arcTo(4.2818656f, 4.2818656f, 0f, false, false, 11.722656f, 8.7949219f)
    arcTo(3.8614116f, 3.8614116f, 0f, false, false, 9.2871094f, 7.9296875f)
    arcTo(3.8614116f, 3.8614116f, 0f, false, false, 5.4257812f, 11.791016f)
    arcTo(3.8614116f, 3.8614116f, 0f, false, false, 5.4335938f, 12.035156f)
    arcTo(3.0096498f, 3.0096498f, 0f, false, false, 4.8671875f, 11.980469f)
    arcTo(3.0096498f, 3.0096498f, 0f, false, false, 1.8574219f, 14.990234f)
    arcTo(3.0096498f, 3.0096498f, 0f, false, false, 4.8671875f, 18f)
    arcTo(3.0096498f, 3.0096498f, 0f, false, false, 4.9316406f, 18f)
    lineTo(19.220703f, 18f)
    lineTo(19.220703f, 17.998047f)
    arcTo(2.5873528f, 2.5873528f, 0f, false, false, 21.742188f, 15.412109f)
    arcTo(2.5873528f, 2.5873528f, 0f, false, false, 19.214844f, 12.826172f)
    arcTo(4.2818656f, 4.2818656f, 0f, false, false, 19.523438f, 11.234375f)
    arcTo(4.2818656f, 4.2818656f, 0f, false, false, 15.240234f, 6.953125f)
    close()
}


val WeatherLightRain = weatherIcon("WeatherLightRain") {
    moveTo(7.7747158f, 16.298471f)
    curveTo(7.7747158f, 16.298471f, 6.3149844f, 17.454229f, 6.1717047f, 18.266809f)
    arcTo(1.237673f, 1.237673f, 0f, false, false, 7.1769077f, 19.699334f)
    arcTo(1.237673f, 1.237673f, 0f, false, false, 8.6094328f, 18.696345f)
    curveTo(8.7527126f, 17.883765f, 7.7747158f, 16.298471f, 7.7747158f, 16.298471f)
    close()
    moveTo(12.3092f, 16.298471f)
    curveTo(12.3092f, 16.298471f, 10.849468f, 17.454229f, 10.706189f, 18.266809f)
    arcTo(1.237673f, 1.237673f, 0f, false, false, 11.711392f, 19.699334f)
    arcTo(1.237673f, 1.237673f, 0f, false, false, 13.143917f, 18.696345f)
    curveTo(13.287198f, 17.883765f, 12.3092f, 16.298471f, 12.3092f, 16.298471f)
    close()
    moveTo(16.843685f, 16.298471f)
    curveTo(16.843685f, 16.298471f, 15.383952f, 17.454229f, 15.240673f, 18.266809f)
    arcTo(1.237673f, 1.237673f, 0f, false, false, 16.245876f, 19.699334f)
    arcTo(1.237673f, 1.237673f, 0f, false, false, 17.678401f, 18.696345f)
    curveTo(17.821682f, 17.883765f, 16.843685f, 16.298471f, 16.843685f, 16.298471f)
    close()
}

val WeatherHail = weatherIcon("WeatherHail") {
    moveTo(7.4093667f, 16.258438f)
    curveTo(6.6975174f, 16.235656f, 6.09006f, 16.947847f, 6.2243877f, 17.647106f)
    curveTo(6.3138584f, 18.353739f, 7.1127111f, 18.841403f, 7.7821731f, 18.599057f)
    curveTo(8.4660776f, 18.399808f, 8.8227568f, 17.533933f, 8.4775745f, 16.910825f)
    curveTo(8.2792236f, 16.515419f, 7.8517895f, 16.254332f, 7.4093667f, 16.258438f)
    close()
    moveTo(11.935705f, 16.258438f)
    curveTo(11.223856f, 16.235656f, 10.616399f, 16.947847f, 10.750726f, 17.647106f)
    curveTo(10.840183f, 18.35367f, 11.639079f, 18.841563f, 12.308486f, 18.598897f)
    curveTo(12.992113f, 18.399396f, 13.348471f, 17.533766f, 13.003396f, 16.910825f)
    curveTo(12.805121f, 16.51558f, 12.377952f, 16.254528f, 11.935705f, 16.258438f)
    close()
    moveTo(16.462044f, 16.258438f)
    curveTo(15.750195f, 16.235656f, 15.142737f, 16.947847f, 15.277065f, 17.647106f)
    curveTo(15.366522f, 18.35367f, 16.165418f, 18.841563f, 16.834825f, 18.598897f)
    curveTo(17.518452f, 18.399396f, 17.87481f, 17.533766f, 17.529735f, 16.910825f)
    curveTo(17.331459f, 16.51558f, 16.904291f, 16.254528f, 16.462044f, 16.258438f)
    close()
}

val WeatherSleetSnow = weatherIcon("WeatherSleetSnow") {
    moveTo(11.935705f, 16.258438f)
    curveTo(11.223856f, 16.235656f, 10.616399f, 16.947847f, 10.750726f, 17.647106f)
    curveTo(10.840183f, 18.35367f, 11.639079f, 18.841563f, 12.308486f, 18.598897f)
    curveTo(12.992113f, 18.399396f, 13.348471f, 17.533766f, 13.003396f, 16.910825f)
    curveTo(12.805121f, 16.51558f, 12.377952f, 16.254528f, 11.935705f, 16.258438f)
    close()
}

val WeatherSleetRain = weatherIcon("WeatherSleetRain") {
    moveTo(6.347656f, 15.96875f)
    curveTo(5.938469f, 15.896599f, 5.550666f, 16.166984f, 5.478515f, 16.576172f)
    lineTo(5.044922f, 19.039062f)
    curveTo(4.972771f, 19.44825f, 5.243156f, 19.836052f, 5.652344f, 19.908203f)
    curveTo(6.061531f, 19.980354f, 6.449333f, 19.708016f, 6.521484f, 19.298828f)
    lineTo(6.955078f, 16.837891f)
    curveTo(7.0272288f, 16.428703f, 6.7568437f, 16.040901f, 6.347656f, 15.96875f)
    close()
    moveTo(18.347656f, 15.96875f)
    curveTo(17.938469f, 15.896599f, 17.550666f, 16.166984f, 17.478516f, 16.576172f)
    lineTo(17.044922f, 19.039062f)
    curveTo(16.972771f, 19.44825f, 17.243156f, 19.836052f, 17.652344f, 19.908203f)
    curveTo(18.061531f, 19.980354f, 18.449333f, 19.708016f, 18.521484f, 19.298828f)
    lineTo(18.955078f, 16.837891f)
    curveTo(19.027229f, 16.428703f, 18.756844f, 16.040901f, 18.347656f, 15.96875f)
    close()
}

val WeatherRain = weatherIcon("WeatherRain") {
    moveTo(6.347656f, 15.96875f)
    curveTo(5.938469f, 15.896599f, 5.550666f, 16.166984f, 5.478515f, 16.576172f)
    lineTo(5.044922f, 19.039062f)
    curveTo(4.972771f, 19.44825f, 5.243156f, 19.836052f, 5.652344f, 19.908203f)
    curveTo(6.061531f, 19.980354f, 6.449333f, 19.708016f, 6.521484f, 19.298828f)
    lineTo(6.955078f, 16.837891f)
    curveTo(7.0272288f, 16.428703f, 6.7568437f, 16.040901f, 6.347656f, 15.96875f)
    close()
    moveTo(9.3476561f, 15.96875f)
    curveTo(8.9384685f, 15.896599f, 8.5506663f, 16.166984f, 8.4785155f, 16.576172f)
    lineTo(8.0449218f, 19.039062f)
    curveTo(7.9727709f, 19.44825f, 8.243156f, 19.836052f, 8.6523436f, 19.908203f)
    curveTo(9.0615312f, 19.980354f, 9.4493334f, 19.708016f, 9.5214842f, 19.298828f)
    lineTo(9.955078f, 16.837891f)
    curveTo(10.027229f, 16.428703f, 9.7568437f, 16.040901f, 9.3476561f, 15.96875f)
    close()
    moveTo(12.347656f, 15.96875f)
    curveTo(11.938469f, 15.896599f, 11.550666f, 16.166984f, 11.478516f, 16.576172f)
    lineTo(11.044922f, 19.039062f)
    curveTo(10.972771f, 19.44825f, 11.243156f, 19.836052f, 11.652344f, 19.908203f)
    curveTo(12.061531f, 19.980354f, 12.449333f, 19.708016f, 12.521484f, 19.298828f)
    lineTo(12.955078f, 16.837891f)
    curveTo(13.027229f, 16.428703f, 12.756844f, 16.040901f, 12.347656f, 15.96875f)
    close()
    moveTo(15.347656f, 15.96875f)
    curveTo(14.938469f, 15.896599f, 14.550666f, 16.166984f, 14.478516f, 16.576172f)
    lineTo(14.044922f, 19.039062f)
    curveTo(13.972771f, 19.44825f, 14.243156f, 19.836052f, 14.652344f, 19.908203f)
    curveTo(15.061531f, 19.980354f, 15.449333f, 19.708016f, 15.521484f, 19.298828f)
    lineTo(15.955078f, 16.837891f)
    curveTo(16.027229f, 16.428703f, 15.756844f, 16.040901f, 15.347656f, 15.96875f)
    close()
    moveTo(18.347656f, 15.96875f)
    curveTo(17.938469f, 15.896599f, 17.550666f, 16.166984f, 17.478516f, 16.576172f)
    lineTo(17.044922f, 19.039062f)
    curveTo(16.972771f, 19.44825f, 17.243156f, 19.836052f, 17.652344f, 19.908203f)
    curveTo(18.061531f, 19.980354f, 18.449333f, 19.708016f, 18.521484f, 19.298828f)
    lineTo(18.955078f, 16.837891f)
    curveTo(19.027229f, 16.428703f, 18.756844f, 16.040901f, 18.347656f, 15.96875f)
    close()
}

val WeatherLightRainAnimatable = weatherIcon("WeatherLightRainAnimatable") {
    moveTo(4.828129f, 0f)
    curveTo(4.828129f, 0f, 3.6375041f, 1.3394488f, 3.6375041f, 2.1332031f)
    curveTo(3.6375041f, 2.7907671f, 4.1705651f, 3.3238281f, 4.828129f, 3.3238281f)
    curveTo(5.485693f, 3.3238281f, 6.018754f, 2.7907671f, 6.018754f, 2.1332031f)
    curveTo(6.018754f, 1.3394488f, 4.828129f, 0f, 4.828129f, 0f)
    close()
    moveTo(12.765629f, 0f)
    curveTo(12.765629f, 0f, 11.575004f, 1.3394488f, 11.575004f, 2.1332031f)
    curveTo(11.575004f, 2.7907671f, 12.108065f, 3.3238281f, 12.765629f, 3.3238281f)
    curveTo(13.423193f, 3.3238281f, 13.956254f, 2.7907671f, 13.956254f, 2.1332031f)
    curveTo(13.956254f, 1.3394488f, 12.765629f, 0f, 12.765629f, 0f)
    close()
    moveTo(20.703129f, 0f)
    curveTo(20.703129f, 0f, 19.512504f, 1.3394488f, 19.512504f, 2.1332031f)
    curveTo(19.512504f, 2.7907671f, 20.045565f, 3.3238281f, 20.703129f, 3.3238281f)
    curveTo(21.360693f, 3.3238281f, 21.893754f, 2.7907671f, 21.893754f, 2.1332031f)
    curveTo(21.893754f, 1.3394488f, 20.703129f, 0f, 20.703129f, 0f)
    close()
    moveTo(8.796879f, 3.96875f)
    curveTo(8.796879f, 3.96875f, 7.606254f, 5.3081983f, 7.606254f, 6.101953f)
    curveTo(7.606254f, 6.759517f, 8.1393151f, 7.292578f, 8.796879f, 7.292578f)
    curveTo(9.4544429f, 7.292578f, 9.987504f, 6.759517f, 9.987504f, 6.101953f)
    curveTo(9.987504f, 5.3081983f, 8.796879f, 3.96875f, 8.796879f, 3.96875f)
    close()
    moveTo(16.734379f, 3.96875f)
    curveTo(16.734379f, 3.96875f, 16.659965f, 4.0524664f, 16.548344f, 4.1904419f)
    curveTo(16.21348f, 4.6043688f, 15.543754f, 5.5066369f, 15.543754f, 6.101953f)
    curveTo(15.54381f, 6.7411813f, 16.048624f, 7.2662972f, 16.687353f, 7.2915446f)
    curveTo(16.70302f, 7.2921986f, 16.718698f, 7.2925434f, 16.734379f, 7.292578f)
    curveTo(17.391943f, 7.292578f, 17.925004f, 6.759517f, 17.925004f, 6.101953f)
    curveTo(17.925004f, 5.3081983f, 16.734379f, 3.96875f, 16.734379f, 3.96875f)
    close()
    moveTo(4.828129f, 7.9374999f)
    curveTo(4.828129f, 7.9374999f, 3.6375041f, 9.2769485f, 3.6375041f, 10.070703f)
    curveTo(3.6375041f, 10.728267f, 4.1705651f, 11.261328f, 4.828129f, 11.261328f)
    curveTo(5.485693f, 11.261328f, 6.018754f, 10.728267f, 6.018754f, 10.070703f)
    curveTo(6.018754f, 9.2769485f, 4.828129f, 7.9374999f, 4.828129f, 7.9374999f)
    close()
    moveTo(12.765629f, 7.9374999f)
    curveTo(12.765629f, 7.9374999f, 12.691215f, 8.0212162f, 12.579594f, 8.1591919f)
    curveTo(12.24473f, 8.5731188f, 11.575004f, 9.4753868f, 11.575004f, 10.070703f)
    curveTo(11.57496f, 10.567853f, 11.883816f, 11.012697f, 12.349634f, 11.186397f)
    curveTo(12.364344f, 11.191857f, 12.379161f, 11.197026f, 12.394075f, 11.2019f)
    curveTo(12.499019f, 11.236323f, 12.608242f, 11.255976f, 12.718603f, 11.260295f)
    curveTo(12.73427f, 11.260949f, 12.749948f, 11.261293f, 12.765629f, 11.261328f)
    curveTo(13.423193f, 11.261328f, 13.956254f, 10.728267f, 13.956254f, 10.070703f)
    curveTo(13.956254f, 9.2769485f, 12.765629f, 7.9374999f, 12.765629f, 7.9374999f)
    close()
    moveTo(20.703129f, 7.9374999f)
    curveTo(20.703129f, 7.9374999f, 20.628715f, 8.0212162f, 20.517094f, 8.1591919f)
    curveTo(20.18223f, 8.5731188f, 19.512504f, 9.4753868f, 19.512504f, 10.070703f)
    curveTo(19.51256f, 10.709931f, 20.017374f, 11.235047f, 20.656103f, 11.260295f)
    curveTo(20.67177f, 11.260949f, 20.687448f, 11.261293f, 20.703129f, 11.261328f)
    curveTo(21.360693f, 11.261328f, 21.893754f, 10.728267f, 21.893754f, 10.070703f)
    curveTo(21.893754f, 9.2769485f, 20.703129f, 7.9374999f, 20.703129f, 7.9374999f)
    close()
    moveTo(8.796879f, 11.90625f)
    curveTo(8.796879f, 11.90625f, 7.606254f, 13.245698f, 7.606254f, 14.039453f)
    curveTo(7.606254f, 14.697017f, 8.1393151f, 15.230078f, 8.796879f, 15.230078f)
    curveTo(9.4544429f, 15.230078f, 9.987504f, 14.697017f, 9.987504f, 14.039453f)
    curveTo(9.987504f, 13.245698f, 8.796879f, 11.90625f, 8.796879f, 11.90625f)
    close()
    moveTo(16.734379f, 11.90625f)
    curveTo(16.734379f, 11.90625f, 15.543754f, 13.245698f, 15.543754f, 14.039453f)
    curveTo(15.543754f, 14.697017f, 16.076815f, 15.230078f, 16.734379f, 15.230078f)
    curveTo(17.391943f, 15.230078f, 17.925004f, 14.697017f, 17.925004f, 14.039453f)
    curveTo(17.925004f, 13.245698f, 16.734379f, 11.90625f, 16.734379f, 11.90625f)
    close()
    moveTo(4.828129f, 15.875f)
    curveTo(4.828129f, 15.875f, 3.6375041f, 17.214448f, 3.6375041f, 18.008203f)
    curveTo(3.6375041f, 18.665767f, 4.1705651f, 19.198828f, 4.828129f, 19.198828f)
    curveTo(5.485693f, 19.198828f, 6.018754f, 18.665767f, 6.018754f, 18.008203f)
    curveTo(6.018754f, 17.214448f, 4.828129f, 15.875f, 4.828129f, 15.875f)
    close()
    moveTo(12.765629f, 15.875f)
    curveTo(12.765629f, 15.875f, 11.575004f, 17.214448f, 11.575004f, 18.008203f)
    curveTo(11.575004f, 18.665767f, 12.108065f, 19.198828f, 12.765629f, 19.198828f)
    curveTo(13.423193f, 19.198828f, 13.956254f, 18.665767f, 13.956254f, 18.008203f)
    curveTo(13.956254f, 17.214448f, 12.765629f, 15.875f, 12.765629f, 15.875f)
    close()
    moveTo(20.703129f, 15.875f)
    curveTo(20.703129f, 15.875f, 19.512504f, 17.214448f, 19.512504f, 18.008203f)
    curveTo(19.512504f, 18.665767f, 20.045565f, 19.198828f, 20.703129f, 19.198828f)
    curveTo(21.360693f, 19.198828f, 21.893754f, 18.665767f, 21.893754f, 18.008203f)
    curveTo(21.893754f, 17.214448f, 20.703129f, 15.875f, 20.703129f, 15.875f)
    close()
}


val WeatherHailAnimatable = weatherIcon("WeatherHailAnimatable") {

    moveTo(4.8281292f, 1.0583334f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 3.5971949f, 2.2892661f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 4.8281292f, 3.5201987f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 6.0585449f, 2.2892661f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 4.8281292f, 1.0583334f)
    close()
    moveTo(12.765629f, 1.0583334f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 11.534695f, 2.2892661f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 12.765629f, 3.5201987f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 13.996045f, 2.2892661f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 12.765629f, 1.0583334f)
    close()
    moveTo(20.703129f, 1.0583334f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 19.472195f, 2.2892661f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 20.703129f, 3.5201987f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 21.933545f, 2.2892661f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 20.703129f, 1.0583334f)
    close()
    moveTo(8.7968792f, 5.0270833f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 7.5659449f, 6.258016f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 8.7968792f, 7.4889487f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 10.027295f, 6.258016f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 8.7968792f, 5.0270833f)
    close()
    moveTo(16.734379f, 5.0270833f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 15.503445f, 6.258016f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 16.734379f, 7.4889487f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 17.964795f, 6.258016f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 16.734379f, 5.0270833f)
    close()
    moveTo(4.8281292f, 8.9958333f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 3.5971949f, 10.226766f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 4.8281292f, 11.457699f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 6.0585449f, 10.226766f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 4.8281292f, 8.9958333f)
    close()
    moveTo(12.765629f, 8.9958333f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 11.534695f, 10.226766f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 12.765629f, 11.457699f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 13.996045f, 10.226766f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 12.765629f, 8.9958333f)
    close()
    moveTo(20.703129f, 8.9958333f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 19.472195f, 10.226766f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 20.703129f, 11.457699f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 21.933545f, 10.226766f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 20.703129f, 8.9958333f)
    close()
    moveTo(8.7968792f, 12.964583f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 7.5659449f, 14.195516f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 8.7968792f, 15.426449f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 10.027295f, 14.195516f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 8.7968792f, 12.964583f)
    close()
    moveTo(16.734379f, 12.964583f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 15.503445f, 14.195516f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 16.734379f, 15.426449f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 17.964795f, 14.195516f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 16.734379f, 12.964583f)
    close()
    moveTo(4.8281292f, 16.933333f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 3.5971949f, 18.164266f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 4.8281292f, 19.395199f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 6.0585449f, 18.164266f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 4.8281292f, 16.933333f)
    close()
    moveTo(12.765629f, 16.933333f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 11.534695f, 18.164266f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 12.765629f, 19.395199f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 13.996045f, 18.164266f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 12.765629f, 16.933333f)
    close()
    moveTo(20.703129f, 16.933333f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 19.472195f, 18.164266f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 20.703129f, 19.395199f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 21.933545f, 18.164266f)
    arcTo(1.2307138f, 1.2307138f, 0f, false, false, 20.703129f, 16.933333f)
    close()
}


val WeatherRainAnimatable = weatherIcon("WeatherRainAnimatable") {

    moveTo(4.828129f, 0.1133928f)
    curveTo(4.41263f, 0.1133928f, 4.0777866f, 0.4477181f, 4.0777866f, 0.8632184f)
    verticalLineTo(4.8634909f)
    curveTo(4.0777866f, 5.278991f, 4.41263f, 5.6133161f, 4.828129f, 5.6133161f)
    curveTo(5.243628f, 5.6133161f, 5.5779529f, 5.278991f, 5.5779529f, 4.8634909f)
    verticalLineTo(0.8632184f)
    curveTo(5.5779529f, 0.4477181f, 5.243628f, 0.1133928f, 4.828129f, 0.1133928f)
    close()
    moveTo(12.765629f, 0.1133928f)
    curveTo(12.35013f, 0.1133928f, 12.015286f, 0.4477181f, 12.015286f, 0.8632184f)
    verticalLineTo(4.8634909f)
    curveTo(12.015286f, 5.278991f, 12.35013f, 5.6133161f, 12.765629f, 5.6133161f)
    curveTo(13.181128f, 5.6133161f, 13.515453f, 5.278991f, 13.515453f, 4.8634909f)
    verticalLineTo(0.8632184f)
    curveTo(13.515453f, 0.4477181f, 13.181128f, 0.1133928f, 12.765629f, 0.1133928f)
    close()
    moveTo(20.703129f, 0.1133928f)
    curveTo(20.28763f, 0.1133928f, 19.952786f, 0.4477181f, 19.952786f, 0.8632184f)
    verticalLineTo(4.8634909f)
    curveTo(19.952786f, 5.278991f, 20.28763f, 5.6133161f, 20.703129f, 5.6133161f)
    curveTo(21.118628f, 5.6133161f, 21.452953f, 5.278991f, 21.452953f, 4.8634909f)
    verticalLineTo(0.8632184f)
    curveTo(21.452953f, 0.4477181f, 21.118628f, 0.1133928f, 20.703129f, 0.1133928f)
    close()
    moveTo(8.796879f, 4.0821433f)
    curveTo(8.3813799f, 4.0821433f, 8.0465365f, 4.4164684f, 8.0465365f, 4.8319684f)
    verticalLineTo(8.8322408f)
    curveTo(8.0465365f, 9.247741f, 8.3813799f, 9.582066f, 8.796879f, 9.582066f)
    curveTo(9.212378f, 9.582066f, 9.5467028f, 9.247741f, 9.5467028f, 8.8322408f)
    verticalLineTo(4.8319684f)
    curveTo(9.5467028f, 4.4164684f, 9.212378f, 4.0821433f, 8.796879f, 4.0821433f)
    close()
    moveTo(16.734379f, 4.0821433f)
    curveTo(16.31888f, 4.0821433f, 15.984036f, 4.4164684f, 15.984036f, 4.8319684f)
    verticalLineTo(8.8322408f)
    curveTo(15.984036f, 9.247741f, 16.31888f, 9.582066f, 16.734379f, 9.582066f)
    curveTo(17.149878f, 9.582066f, 17.484203f, 9.247741f, 17.484203f, 8.8322408f)
    verticalLineTo(4.8319684f)
    curveTo(17.484203f, 4.4164684f, 17.149878f, 4.0821433f, 16.734379f, 4.0821433f)
    close()
    moveTo(4.828129f, 8.0508932f)
    curveTo(4.41263f, 8.0508932f, 4.0777866f, 8.3852183f, 4.0777866f, 8.8007184f)
    verticalLineTo(12.800991f)
    curveTo(4.0777866f, 13.216491f, 4.41263f, 13.550816f, 4.828129f, 13.550816f)
    curveTo(5.243628f, 13.550816f, 5.5779529f, 13.216491f, 5.5779529f, 12.800991f)
    verticalLineTo(8.8007184f)
    curveTo(5.5779529f, 8.3852183f, 5.243628f, 8.0508932f, 4.828129f, 8.0508932f)
    close()
    moveTo(12.765629f, 8.0508932f)
    curveTo(12.35013f, 8.0508932f, 12.015286f, 8.3852183f, 12.015286f, 8.8007184f)
    verticalLineTo(12.800991f)
    curveTo(12.015286f, 13.216491f, 12.35013f, 13.550816f, 12.765629f, 13.550816f)
    curveTo(13.181128f, 13.550816f, 13.515453f, 13.216491f, 13.515453f, 12.800991f)
    verticalLineTo(8.8007184f)
    curveTo(13.515453f, 8.3852183f, 13.181128f, 8.0508932f, 12.765629f, 8.0508932f)
    close()
    moveTo(20.703129f, 8.0508932f)
    curveTo(20.28763f, 8.0508932f, 19.952786f, 8.3852183f, 19.952786f, 8.8007184f)
    verticalLineTo(12.800991f)
    curveTo(19.952786f, 13.216491f, 20.28763f, 13.550816f, 20.703129f, 13.550816f)
    curveTo(21.118628f, 13.550816f, 21.452953f, 13.216491f, 21.452953f, 12.800991f)
    verticalLineTo(8.8007184f)
    curveTo(21.452953f, 8.3852183f, 21.118628f, 8.0508932f, 20.703129f, 8.0508932f)
    close()
    moveTo(8.796879f, 12.019643f)
    curveTo(8.3813799f, 12.019643f, 8.0465365f, 12.353968f, 8.0465365f, 12.769468f)
    verticalLineTo(16.769741f)
    curveTo(8.0465365f, 17.185241f, 8.3813799f, 17.519566f, 8.796879f, 17.519566f)
    curveTo(9.212378f, 17.519566f, 9.5467028f, 17.185241f, 9.5467028f, 16.769741f)
    verticalLineTo(12.769468f)
    curveTo(9.5467028f, 12.353968f, 9.212378f, 12.019643f, 8.796879f, 12.019643f)
    close()
    moveTo(16.734379f, 12.019643f)
    curveTo(16.31888f, 12.019643f, 15.984036f, 12.353968f, 15.984036f, 12.769468f)
    verticalLineTo(16.769741f)
    curveTo(15.984036f, 17.185241f, 16.31888f, 17.519566f, 16.734379f, 17.519566f)
    curveTo(17.149878f, 17.519566f, 17.484203f, 17.185241f, 17.484203f, 16.769741f)
    verticalLineTo(12.769468f)
    curveTo(17.484203f, 12.353968f, 17.149878f, 12.019643f, 16.734379f, 12.019643f)
    close()
    moveTo(4.828129f, 15.988393f)
    curveTo(4.41263f, 15.988393f, 4.0777866f, 16.322718f, 4.0777866f, 16.738218f)
    verticalLineTo(20.738491f)
    curveTo(4.0777866f, 21.153991f, 4.41263f, 21.488316f, 4.828129f, 21.488316f)
    curveTo(5.243628f, 21.488316f, 5.5779529f, 21.153991f, 5.5779529f, 20.738491f)
    verticalLineTo(16.738218f)
    curveTo(5.5779529f, 16.322718f, 5.243628f, 15.988393f, 4.828129f, 15.988393f)
    close()
    moveTo(12.765629f, 15.988393f)
    curveTo(12.35013f, 15.988393f, 12.015286f, 16.322718f, 12.015286f, 16.738218f)
    verticalLineTo(20.738491f)
    curveTo(12.015286f, 21.153991f, 12.35013f, 21.488316f, 12.765629f, 21.488316f)
    curveTo(13.181128f, 21.488316f, 13.515453f, 21.153991f, 13.515453f, 20.738491f)
    verticalLineTo(16.738218f)
    curveTo(13.515453f, 16.322718f, 13.181128f, 15.988393f, 12.765629f, 15.988393f)
    close()
    moveTo(20.703129f, 15.988393f)
    curveTo(20.28763f, 15.988393f, 19.952786f, 16.322718f, 19.952786f, 16.738218f)
    verticalLineTo(20.738491f)
    curveTo(19.952786f, 21.153991f, 20.28763f, 21.488316f, 20.703129f, 21.488316f)
    curveTo(21.118628f, 21.488316f, 21.452953f, 21.153991f, 21.452953f, 20.738491f)
    verticalLineTo(16.738218f)
    curveTo(21.452953f, 16.322718f, 21.118628f, 15.988393f, 20.703129f, 15.988393f)
    close()

}

val WeatherSleetRainAnimatable = weatherIcon("WeatherSleetRainAnimatable") {

        moveTo(4.8281293f, 0.11317139f)
        curveTo(4.4126296f, 0.11317139f, 4.0777866f, 0.44749611f, 4.0777866f, 0.86299642f)
        verticalLineTo(4.8632689f)
        curveTo(4.0777866f, 5.278769f, 4.4126296f, 5.6130941f, 4.8281293f, 5.6130941f)
        curveTo(5.2436283f, 5.6130941f, 5.5779543f, 5.278769f, 5.5779543f, 4.8632689f)
        verticalLineTo(0.86299642f)
        curveTo(5.5779543f, 0.44749611f, 5.2436283f, 0.11317139f, 4.8281293f, 0.11317139f)
        close()
        moveTo(12.765629f, 0.11317139f)
        curveTo(12.35013f, 0.11317139f, 12.015287f, 0.44749611f, 12.015287f, 0.86299642f)
        verticalLineTo(4.8632689f)
        curveTo(12.015287f, 5.278769f, 12.35013f, 5.6130941f, 12.765629f, 5.6130941f)
        curveTo(13.181128f, 5.6130941f, 13.515454f, 5.278769f, 13.515454f, 4.8632689f)
        verticalLineTo(0.86299642f)
        curveTo(13.515454f, 0.44749611f, 13.181128f, 0.11317139f, 12.765629f, 0.11317139f)
        close()
        moveTo(20.703129f, 0.11317139f)
        curveTo(20.287629f, 0.11317139f, 19.952787f, 0.44749611f, 19.952787f, 0.86299642f)
        verticalLineTo(4.8632689f)
        curveTo(19.952787f, 5.278769f, 20.287629f, 5.6130941f, 20.703129f, 5.6130941f)
        curveTo(21.118628f, 5.6130941f, 21.452953f, 5.278769f, 21.452953f, 4.8632689f)
        verticalLineTo(0.86299642f)
        curveTo(21.452953f, 0.44749611f, 21.118628f, 0.11317139f, 20.703129f, 0.11317139f)
        close()
        moveTo(4.8281293f, 8.0506712f)
        curveTo(4.4126296f, 8.0506712f, 4.0777866f, 8.3849963f, 4.0777866f, 8.8004964f)
        verticalLineTo(12.800769f)
        curveTo(4.0777866f, 13.216269f, 4.4126296f, 13.550594f, 4.8281293f, 13.550594f)
        curveTo(5.2436283f, 13.550594f, 5.5779543f, 13.216269f, 5.5779543f, 12.800769f)
        verticalLineTo(8.8004964f)
        curveTo(5.5779543f, 8.3849963f, 5.2436283f, 8.0506712f, 4.8281293f, 8.0506712f)
        close()
        moveTo(12.765629f, 8.0506712f)
        curveTo(12.35013f, 8.0506712f, 12.015287f, 8.3849963f, 12.015287f, 8.8004964f)
        verticalLineTo(12.800769f)
        curveTo(12.015287f, 13.216269f, 12.35013f, 13.550594f, 12.765629f, 13.550594f)
        curveTo(13.181128f, 13.550594f, 13.515454f, 13.216269f, 13.515454f, 12.800769f)
        verticalLineTo(8.8004964f)
        curveTo(13.515454f, 8.3849963f, 13.181128f, 8.0506712f, 12.765629f, 8.0506712f)
        close()
        moveTo(20.703129f, 8.0506712f)
        curveTo(20.287629f, 8.0506712f, 19.952787f, 8.3849963f, 19.952787f, 8.8004964f)
        verticalLineTo(12.800769f)
        curveTo(19.952787f, 13.216269f, 20.287629f, 13.550594f, 20.703129f, 13.550594f)
        curveTo(21.118628f, 13.550594f, 21.452953f, 13.216269f, 21.452953f, 12.800769f)
        verticalLineTo(8.8004964f)
        curveTo(21.452953f, 8.3849963f, 21.118628f, 8.0506712f, 20.703129f, 8.0506712f)
        close()
        moveTo(4.8281293f, 15.988171f)
        curveTo(4.4126296f, 15.988171f, 4.0777866f, 16.322496f, 4.0777866f, 16.737996f)
        verticalLineTo(20.738269f)
        curveTo(4.0777866f, 21.153769f, 4.4126296f, 21.488094f, 4.8281293f, 21.488094f)
        curveTo(5.2436283f, 21.488094f, 5.5779543f, 21.153769f, 5.5779543f, 20.738269f)
        verticalLineTo(16.737996f)
        curveTo(5.5779543f, 16.322496f, 5.2436283f, 15.988171f, 4.8281293f, 15.988171f)
        close()
        moveTo(12.765629f, 15.988171f)
        curveTo(12.35013f, 15.988171f, 12.015287f, 16.322496f, 12.015287f, 16.737996f)
        verticalLineTo(20.738269f)
        curveTo(12.015287f, 21.153769f, 12.35013f, 21.488094f, 12.765629f, 21.488094f)
        curveTo(13.181128f, 21.488094f, 13.515454f, 21.153769f, 13.515454f, 20.738269f)
        verticalLineTo(16.737996f)
        curveTo(13.515454f, 16.322496f, 13.181128f, 15.988171f, 12.765629f, 15.988171f)
        close()
        moveTo(20.703129f, 15.988171f)
        curveTo(20.287629f, 15.988171f, 19.952787f, 16.322496f, 19.952787f, 16.737996f)
        verticalLineTo(20.738269f)
        curveTo(19.952787f, 21.153769f, 20.287629f, 21.488094f, 20.703129f, 21.488094f)
        curveTo(21.118628f, 21.488094f, 21.452953f, 21.153769f, 21.452953f, 20.738269f)
        verticalLineTo(16.737996f)
        curveTo(21.452953f, 16.322496f, 21.118628f, 15.988171f, 20.703129f, 15.988171f)
        close()
    }

val WeatherSleetSnowAnimatable = weatherIcon("WeatherSleetSnowAnimatable") {

        moveTo(8.796879f, 5.0270833f)
        curveTo(7.8632606f, 4.9745641f, 7.2031834f, 6.1917513f, 7.7668228f, 6.9446931f)
        curveTo(8.2182954f, 7.6432508f, 9.3919824f, 7.6787827f, 9.8262364f, 6.9412491f)
        curveTo(10.250965f, 6.3103634f, 9.9588313f, 5.3184227f, 9.2064902f, 5.0975184f)
        curveTo(9.0753076f, 5.0509595f, 8.9361544f, 5.0263693f, 8.796879f, 5.0270833f)
        close()
        moveTo(16.734379f, 5.0270833f)
        curveTo(15.800761f, 4.974564f, 15.140683f, 6.1917512f, 15.704322f, 6.9446931f)
        curveTo(16.155795f, 7.643251f, 17.329482f, 7.6787825f, 17.763736f, 6.9412491f)
        curveTo(18.188465f, 6.3103636f, 17.896331f, 5.3184225f, 17.14399f, 5.0975184f)
        curveTo(17.012808f, 5.0509596f, 16.873654f, 5.0263694f, 16.734379f, 5.0270833f)
        close()
        moveTo(8.796879f, 12.964583f)
        curveTo(7.8632606f, 12.912064f, 7.2031834f, 14.129251f, 7.7668228f, 14.882193f)
        curveTo(8.2182957f, 15.580751f, 9.3919822f, 15.616282f, 9.8262364f, 14.878749f)
        curveTo(10.250965f, 14.247863f, 9.9588308f, 13.255923f, 9.2064902f, 13.035018f)
        curveTo(9.0753077f, 12.988459f, 8.9361544f, 12.963869f, 8.796879f, 12.964583f)
        close()
        moveTo(16.734379f, 12.964583f)
        curveTo(15.800761f, 12.912064f, 15.140683f, 14.129251f, 15.704322f, 14.882193f)
        curveTo(16.155795f, 15.580751f, 17.329482f, 15.616282f, 17.763736f, 14.878749f)
        curveTo(18.188465f, 14.247863f, 17.896331f, 13.255923f, 17.14399f, 13.035018f)
        curveTo(17.012808f, 12.988459f, 16.873654f, 12.963869f, 16.734379f, 12.964583f)
        close()
    }

val WeatherFog = weatherIcon("WeatherFog") {
        moveTo(9.7558594f, 9.9609375f)
        curveTo(9.2018594f, 9.9609375f, 8.7558594f, 10.406937f, 8.7558594f, 10.960938f)
        curveTo(8.7558594f, 11.514938f, 9.2018594f, 11.960938f, 9.7558594f, 11.960938f)
        lineTo(19.662109f, 11.960938f)
        curveTo(20.216109f, 11.960937f, 20.662109f, 11.514938f, 20.662109f, 10.960938f)
        curveTo(20.662109f, 10.406937f, 20.216109f, 9.9609375f, 19.662109f, 9.9609375f)
        lineTo(9.7558594f, 9.9609375f)
        close()
        moveTo(2.390625f, 12.818359f)
        curveTo(1.836625f, 12.818359f, 1.390625f, 13.264359f, 1.390625f, 13.818359f)
        curveTo(1.390625f, 14.372359f, 1.836625f, 14.818359f, 2.390625f, 14.818359f)
        lineTo(11.5625f, 14.818359f)
        curveTo(12.1165f, 14.818359f, 12.5625f, 14.372359f, 12.5625f, 13.818359f)
        curveTo(12.5625f, 13.264359f, 12.1165f, 12.818359f, 11.5625f, 12.818359f)
        lineTo(2.390625f, 12.818359f)
        close()
        moveTo(14.847656f, 12.818359f)
        curveTo(14.293656f, 12.818359f, 13.847656f, 13.264359f, 13.847656f, 13.818359f)
        curveTo(13.847656f, 14.372359f, 14.293656f, 14.818359f, 14.847656f, 14.818359f)
        lineTo(21.183594f, 14.818359f)
        curveTo(21.737594f, 14.818359f, 22.183594f, 14.372359f, 22.183594f, 13.818359f)
        curveTo(22.183594f, 13.264359f, 21.737594f, 12.818359f, 21.183594f, 12.818359f)
        lineTo(14.847656f, 12.818359f)
        close()
    }

val Rain = weatherIcon("Rain") {

        moveTo(13.95f, 21.9f)
        quadToRelative(-0.375f, 0.2f, -0.762f, 0.062f)
        quadToRelative(-0.388f, -0.137f, -0.588f, -0.512f)
        lineToRelative(-1.5f, -3f)
        quadToRelative(-0.2f, -0.375f, -0.062f, -0.762f)
        quadToRelative(0.137f, -0.388f, 0.512f, -0.588f)
        quadToRelative(0.375f, -0.2f, 0.762f, -0.062f)
        quadToRelative(0.388f, 0.137f, 0.588f, 0.512f)
        lineToRelative(1.5f, 3f)
        quadToRelative(0.2f, 0.375f, 0.063f, 0.762f)
        quadToRelative(-0.138f, 0.388f, -0.513f, 0.588f)
        close()
        moveToRelative(6f, 0f)
        quadToRelative(-0.375f, 0.2f, -0.762f, 0.062f)
        quadToRelative(-0.388f, -0.137f, -0.588f, -0.512f)
        lineToRelative(-1.5f, -3f)
        quadToRelative(-0.2f, -0.375f, -0.062f, -0.762f)
        quadToRelative(0.137f, -0.388f, 0.512f, -0.588f)
        quadToRelative(0.375f, -0.2f, 0.762f, -0.062f)
        quadToRelative(0.388f, 0.137f, 0.588f, 0.512f)
        lineToRelative(1.5f, 3f)
        quadToRelative(0.2f, 0.375f, 0.063f, 0.762f)
        quadToRelative(-0.138f, 0.388f, -0.513f, 0.588f)
        close()
        moveToRelative(-12f, 0f)
        quadToRelative(-0.375f, 0.2f, -0.762f, 0.062f)
        quadToRelative(-0.388f, -0.137f, -0.588f, -0.512f)
        lineToRelative(-1.5f, -3f)
        quadToRelative(-0.2f, -0.375f, -0.062f, -0.762f)
        quadToRelative(0.137f, -0.388f, 0.512f, -0.588f)
        quadToRelative(0.375f, -0.2f, 0.762f, -0.062f)
        quadToRelative(0.388f, 0.137f, 0.588f, 0.512f)
        lineToRelative(1.5f, 3f)
        quadToRelative(0.2f, 0.375f, 0.063f, 0.762f)
        quadToRelative(-0.138f, 0.388f, -0.513f, 0.588f)
        close()
        moveTo(7.5f, 16f)
        quadToRelative(-2.275f, 0f, -3.887f, -1.613f)
        quadTo(2f, 12.775f, 2f, 10.5f)
        quadToRelative(0f, -2.075f, 1.375f, -3.625f)
        quadToRelative(1.375f, -1.55f, 3.4f, -1.825f)
        quadToRelative(0.8f, -1.425f, 2.188f, -2.238f)
        quadTo(10.35f, 2f, 12f, 2f)
        quadToRelative(2.25f, 0f, 3.912f, 1.438f)
        quadToRelative(1.663f, 1.437f, 2.013f, 3.587f)
        quadToRelative(1.725f, 0.15f, 2.9f, 1.425f)
        quadTo(22f, 9.725f, 22f, 11.5f)
        quadToRelative(0f, 1.875f, -1.312f, 3.188f)
        quadTo(19.375f, 16f, 17.5f, 16f)
        close()
        moveToRelative(0f, -2f)
        horizontalLineToRelative(10f)
        quadToRelative(1.05f, 0f, 1.775f, -0.725f)
        quadTo(20f, 12.55f, 20f, 11.5f)
        quadToRelative(0f, -1.05f, -0.725f, -1.775f)
        quadTo(18.55f, 9f, 17.5f, 9f)
        horizontalLineTo(16f)
        verticalLineTo(8f)
        quadToRelative(0f, -1.65f, -1.175f, -2.825f)
        quadTo(13.65f, 4f, 12f, 4f)
        quadToRelative(-1.2f, 0f, -2.188f, 0.65f)
        quadToRelative(-0.987f, 0.65f, -1.487f, 1.75f)
        lineToRelative(-0.25f, 0.6f)
        horizontalLineTo(7.45f)
        quadToRelative(-1.425f, 0.05f, -2.437f, 1.062f)
        quadTo(4f, 9.075f, 4f, 10.5f)
        quadToRelative(0f, 1.45f, 1.025f, 2.475f)
        quadTo(6.05f, 14f, 7.5f, 14f)
        close()
        moveTo(12f, 9f)
        close()

    }

val HumidityPercentage = weatherIcon("HumidityPercentage") {

    moveTo(14.5f, 18f)
    quadToRelative(0.625f, 0f, 1.062f, -0.438f)
    quadTo(16f, 17.125f, 16f, 16.5f)
    reflectiveQuadToRelative(-0.438f, -1.062f)
    quadTo(15.125f, 15f, 14.5f, 15f)
    reflectiveQuadToRelative(-1.062f, 0.438f)
    quadTo(13f, 15.875f, 13f, 16.5f)
    reflectiveQuadToRelative(0.438f, 1.062f)
    quadTo(13.875f, 18f, 14.5f, 18f)
    close()
    moveToRelative(-5.75f, -0.75f)
    quadToRelative(0.3f, 0.3f, 0.7f, 0.3f)
    quadToRelative(0.4f, 0f, 0.7f, -0.3f)
    lineToRelative(5.1f, -5.1f)
    quadToRelative(0.3f, -0.3f, 0.3f, -0.7f)
    quadToRelative(0f, -0.4f, -0.3f, -0.7f)
    quadToRelative(-0.3f, -0.3f, -0.712f, -0.3f)
    quadToRelative(-0.413f, 0f, -0.713f, 0.3f)
    lineTo(8.75f, 15.825f)
    quadToRelative(-0.3f, 0.3f, -0.3f, 0.713f)
    quadToRelative(0f, 0.412f, 0.3f, 0.712f)
    close()
    moveTo(9.5f, 13f)
    quadToRelative(0.625f, 0f, 1.062f, -0.438f)
    quadTo(11f, 12.125f, 11f, 11.5f)
    reflectiveQuadToRelative(-0.438f, -1.062f)
    quadTo(10.125f, 10f, 9.5f, 10f)
    reflectiveQuadToRelative(-1.062f, 0.438f)
    quadTo(8f, 10.875f, 8f, 11.5f)
    reflectiveQuadToRelative(0.438f, 1.062f)
    quadTo(8.875f, 13f, 9.5f, 13f)
    close()
    moveToRelative(2.5f, 9f)
    quadToRelative(-3.175f, 0f, -5.587f, -2.212f)
    quadTo(4f, 17.575f, 4f, 13.8f)
    quadToRelative(0f, -2.375f, 1.8f, -5.15f)
    quadToRelative(1.8f, -2.775f, 5.45f, -6f)
    quadToRelative(0.15f, -0.125f, 0.35f, -0.2f)
    quadToRelative(0.2f, -0.075f, 0.4f, -0.075f)
    reflectiveQuadToRelative(0.4f, 0.075f)
    quadToRelative(0.2f, 0.075f, 0.35f, 0.2f)
    quadToRelative(3.65f, 3.225f, 5.45f, 6f)
    quadTo(20f, 11.425f, 20f, 13.8f)
    quadToRelative(0f, 3.775f, -2.413f, 5.988f)
    quadTo(15.175f, 22f, 12f, 22f)
    close()
    moveToRelative(0f, -2f)
    quadToRelative(2.525f, 0f, 4.262f, -1.725f)
    quadTo(18f, 16.55f, 18f, 13.8f)
    quadToRelative(0f, -1.775f, -1.475f, -4.063f)
    quadTo(15.05f, 7.45f, 12f, 4.65f)
    quadToRelative(-3.05f, 2.8f, -4.525f, 5.087f)
    quadTo(6f, 12.025f, 6f, 13.8f)
    quadToRelative(0f, 2.75f, 1.737f, 4.475f)
    quadTo(9.475f, 20f, 12f, 20f)
    close()
    moveToRelative(0f, -6.2f)
    close()
}
