plugins {
	alias(libs.plugins.android.application)
}

android {
	namespace = "de.markusfisch.android.shadereditor"

	compileSdk = 36

	defaultConfig {
		minSdk = 23
		targetSdk = compileSdk

		versionCode = 92
		versionName = "2.36.1"

		vectorDrawables {
			useSupportLibrary = true
		}
	}


	buildTypes {
		debug {
			applicationIdSuffix = ".debug"
		}

		release {
			isMinifyEnabled = true
			isShrinkResources = true
		}
	}

	buildFeatures {
		buildConfig = true
		viewBinding = true
	}

	compileOptions {
		sourceCompatibility = JavaVersion.VERSION_17
		targetCompatibility = JavaVersion.VERSION_17
	}
}

dependencies {
	implementation(libs.androidx.appcompat)
	implementation(libs.material)
	implementation(libs.androidx.preference)

	implementation (libs.androidx.camera.core)
	implementation(libs.androidx.camera.camera2)
	implementation(libs.androidx.camera.lifecycle)
}
