package de.lxtools.noteshop.ui.recipes

import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.material3.AlertDialog
import androidx.compose.material3.Button
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.OutlinedTextField
import androidx.compose.material3.Text
import androidx.compose.material3.TextButton
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.unit.dp
import de.lxtools.noteshop.DynamicRecipeStrings
import de.lxtools.noteshop.R

@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun RecipeInputDialog(
    recipeDetails: RecipeDetails,
    onValueChange: (RecipeDetails) -> Unit,
    onSave: () -> Unit,
    onDismiss: () -> Unit,
    onImport: () -> Unit,
    isNewRecipe: Boolean,
    dynamicRecipeStrings: DynamicRecipeStrings,
    modifier: Modifier = Modifier
) {
    AlertDialog(
        onDismissRequest = onDismiss,
        title = { Text(text = if (isNewRecipe) dynamicRecipeStrings.addItem else dynamicRecipeStrings.editItem) },
        text = {
            Column {
                OutlinedTextField(
                    value = recipeDetails.title,
                    onValueChange = { onValueChange(recipeDetails.copy(title = it)) },
                    label = { Text(dynamicRecipeStrings.itemTitle) },
                    modifier = Modifier.fillMaxWidth()
                )
                if (isNewRecipe) {
                    Spacer(modifier = Modifier.height(16.dp))
                    Button(onClick = onImport, modifier = Modifier.fillMaxWidth()) {
                        Text(dynamicRecipeStrings.importButton)
                    }
                }
            }
        },
        confirmButton = {
            Button(onClick = onSave, enabled = recipeDetails.isValid()) {
                Text(stringResource(R.string.save))
            }
        },
        dismissButton = {
            TextButton(onClick = onDismiss) {
                Text(stringResource(R.string.cancel))
            }
        },
        modifier = modifier
    )
}
