package de.lxtools.noteshop.ui.notes

import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.material3.AlertDialog
import androidx.compose.material3.Button
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.OutlinedTextField
import androidx.compose.material3.Text
import androidx.compose.material3.TextButton
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.unit.dp
import de.lxtools.noteshop.R

@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun NoteInputDialog(
    noteDetails: NoteDetails,
    onValueChange: (NoteDetails) -> Unit,
    onSave: () -> Unit,
    onDismiss: () -> Unit,
    onImport: () -> Unit,
    isNewNote: Boolean,
    modifier: Modifier = Modifier
) {
    AlertDialog(
        onDismissRequest = onDismiss,
        title = { Text(text = if (isNewNote) stringResource(R.string.add_note) else stringResource(R.string.edit_note)) },
        text = {
            Column {
                OutlinedTextField(
                    value = noteDetails.title,
                    onValueChange = { onValueChange(noteDetails.copy(title = it)) },
                    label = { Text(stringResource(R.string.note_title)) },
                    modifier = Modifier.fillMaxWidth()
                )
                if (isNewNote) {
                    Spacer(modifier = Modifier.height(16.dp))
                    Button(onClick = onImport, modifier = Modifier.fillMaxWidth()) {
                        Text(stringResource(R.string.import_from_txt))
                    }
                }
            }
        },
        confirmButton = {
            Button(onClick = onSave, enabled = noteDetails.isValid()) {
                Text(stringResource(R.string.save))
            }
        },
        dismissButton = {
            TextButton(onClick = onDismiss) {
                Text(stringResource(R.string.cancel))
            }
        },
        modifier = modifier
    )
}
