package de.lxtools.noteshop.ui.appshell


import androidx.activity.result.ActivityResultLauncher
import androidx.compose.runtime.Composable
import androidx.compose.runtime.rememberCoroutineScope
import de.lxtools.noteshop.BiometricAuthenticator
import de.lxtools.noteshop.R
import de.lxtools.noteshop.getDynamicRecipeStrings
import de.lxtools.noteshop.ui.JsonImportExportDialog
import de.lxtools.noteshop.ui.RenameDialog
import de.lxtools.noteshop.ui.UnlockPasswordDialog
import de.lxtools.noteshop.ui.notes.NoteDetails
import de.lxtools.noteshop.ui.notes.NoteInputDialog
import de.lxtools.noteshop.ui.notes.NotesViewModel
import de.lxtools.noteshop.ui.notes.SetPasswordDialog
import de.lxtools.noteshop.ui.recipes.RecipeDetails
import de.lxtools.noteshop.ui.recipes.RecipeInputDialog
import de.lxtools.noteshop.ui.recipes.RecipesViewModel
import de.lxtools.noteshop.ui.shopping.ShoppingListDetails
import de.lxtools.noteshop.ui.shopping.ShoppingListInputDialog
import de.lxtools.noteshop.ui.ChooseLockMethodDialog
import de.lxtools.noteshop.ui.LockMethod
import de.lxtools.noteshop.ui.shopping.ShoppingListsViewModel
import kotlinx.coroutines.launch
import androidx.compose.ui.platform.LocalContext
import de.lxtools.noteshop.findActivity
import de.lxtools.noteshop.security.hashString

@Composable
fun AppDialogs(
    mainActivityViewModel: de.lxtools.noteshop.MainActivityViewModel,
    notesViewModel: NotesViewModel,
    shoppingListsViewModel: ShoppingListsViewModel,
    recipesViewModel: RecipesViewModel,
    showListDialog: Boolean,
    onShowListDialogChange: (Boolean) -> Unit,
    listDetails: ShoppingListDetails,
    onListDetailsChange: (ShoppingListDetails) -> Unit,


    onSetListProtection: (String) -> Unit,

    txtImportLauncher: ActivityResultLauncher<Array<String>>,
    showNoteDialog: Boolean,
    onShowNoteDialogChange: (Boolean) -> Unit,
    noteDetails: NoteDetails,
    onNoteDetailsChange: (NoteDetails) -> Unit,



    noteImportLauncher: ActivityResultLauncher<Array<String>>,
    showRecipeDialog: Boolean,
    onShowRecipeDialogChange: (Boolean) -> Unit,
    recipeDetails: RecipeDetails,
    onRecipeDetailsChange: (RecipeDetails) -> Unit,



    recipeImportLauncher: ActivityResultLauncher<Array<String>>,
    recipesTitle: String,
    showJsonDialog: Boolean,
    onShowJsonDialogChange: (Boolean) -> Unit,
    shoppingListsTitle: String,
    biometricAuthenticator: BiometricAuthenticator,
    showSetPasswordDialog: Boolean,
    onShowSetPasswordDialogChange: (Boolean) -> Unit,
    onSetNotePassword: (String) -> Unit,
    showSetRecipePasswordDialog: Boolean,
    onShowSetRecipePasswordDialogChange: (Boolean) -> Unit,
    onSetRecipePassword: (String) -> Unit,
    showSetListPasswordDialog: Boolean,
    onShowSetListPasswordDialogChange: (Boolean) -> Unit,
    showUnlockPasswordDialog: Boolean,
    onShowUnlockPasswordDialogChange: (Boolean) -> Unit,
    onUnlock: (String) -> Unit,
    unlockErrorMessage: String?,
    sharedPrefs: android.content.SharedPreferences,
    showRenameDialog: Boolean,
    onShowRenameDialogChange: (Boolean) -> Unit,
    onRenameShoppingListsTitle: (String) -> Unit,
    showRecipeRenameDialog: Boolean,
    onShowRecipeRenameDialogChange: (Boolean) -> Unit,
    onRenameRecipesTitle: (String) -> Unit,
    showChooseLockMethodDialog: Boolean,
    onShowChooseLockMethodDialogChange: (Boolean) -> Unit,
    onConfirmLockMethod: (LockMethod) -> Unit,
    canUseBiometrics: Boolean
) {
    val context = LocalContext.current
    val scope = rememberCoroutineScope()
    val dynamicRecipeStrings = getDynamicRecipeStrings(recipesTitle)

    if (showListDialog) {
        ShoppingListInputDialog(
            listDetails = listDetails,
            onValueChange = onListDetailsChange,
            onSave = {
                scope.launch {
                    shoppingListsViewModel.saveList()
                    onShowListDialogChange(false)
                }
            },
            onDismiss = { onShowListDialogChange(false) },
            onImportFromTxt = {
                txtImportLauncher.launch(arrayOf("text/plain"))
            },
            isNewList = listDetails.id == 0
        )
    }

    if (showNoteDialog) {
        NoteInputDialog(
            noteDetails = noteDetails,
            onValueChange = onNoteDetailsChange,
            onSave = {
                scope.launch {
                    notesViewModel.saveNote()
                    onShowNoteDialogChange(false)
                }
            },
            onDismiss = { onShowNoteDialogChange(false) },
            onImport = {
                noteImportLauncher.launch(arrayOf("text/plain"))
                onShowNoteDialogChange(false)
            },
            isNewNote = noteDetails.id == 0
        )
    }

    if (showRecipeDialog) {
        RecipeInputDialog(
            recipeDetails = recipeDetails,
            onValueChange = onRecipeDetailsChange,
            onSave = {
                scope.launch {
                    recipesViewModel.saveRecipe()
                    onShowRecipeDialogChange(false)
                }
            },
            onDismiss = { onShowRecipeDialogChange(false) },
            onImport = {
                recipeImportLauncher.launch(arrayOf("text/plain", "text/markdown"))
                onShowRecipeDialogChange(false)
            },
            isNewRecipe = recipeDetails.id == 0,
            dynamicRecipeStrings = dynamicRecipeStrings
        )
    }

    if (showJsonDialog) {
        JsonImportExportDialog(
            onDismissRequest = { onShowJsonDialogChange(false) },
            notesViewModel = notesViewModel,
            shoppingListsViewModel = shoppingListsViewModel,
            recipesViewModel = recipesViewModel,
            shoppingListsTitle = shoppingListsTitle,
            recipesTitle = recipesTitle,
        )
    }

    if (showSetPasswordDialog) {
        SetPasswordDialog(
            onDismiss = { onShowSetPasswordDialogChange(false) },
            onSetPassword = { password ->
                onSetNotePassword(password)
                onShowSetPasswordDialogChange(false)
            }
        )
    }

    if (showSetRecipePasswordDialog) {
        SetPasswordDialog(
            onDismiss = { onShowSetRecipePasswordDialogChange(false) },
            onSetPassword = { password ->
                onSetRecipePassword(password)
                onShowSetRecipePasswordDialogChange(false)
            }
        )
    }

    if (showSetListPasswordDialog) {
        SetPasswordDialog(
            onDismiss = { onShowSetListPasswordDialogChange(false) },
            onSetPassword = { password ->
                onSetListProtection(password)
                onShowSetListPasswordDialogChange(false)
            }
        )
    }

    if (showRecipeRenameDialog) {
        RenameDialog(
            currentTitle = recipesTitle,
            onDismiss = { onShowRecipeRenameDialogChange(false) },
            onSave = { newTitle ->
                onRenameRecipesTitle(newTitle)
                onShowRecipeRenameDialogChange(false)
            }
        )
    }

    if (showUnlockPasswordDialog) {
        UnlockPasswordDialog(
            onDismiss = {
                onShowUnlockPasswordDialogChange(false)
            },
            onUnlock = onUnlock,
            errorMessage = unlockErrorMessage
        )
    }

    if (showChooseLockMethodDialog) {
        ChooseLockMethodDialog(
            onDismiss = { onShowChooseLockMethodDialogChange(false) },
            onConfirm = { lockMethod ->
                onConfirmLockMethod(lockMethod)
            },
            canUseBiometrics = canUseBiometrics
        )
    }
}