package de.lxtools.noteshop.ui

import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.background
import androidx.compose.material3.Button
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.unit.dp


import de.lxtools.noteshop.R
import androidx.compose.foundation.pager.rememberPagerState
import androidx.compose.foundation.pager.HorizontalPager

@Composable
fun GuidedTourScreen(onTourFinished: () -> Unit) {
    val pagerState = rememberPagerState(pageCount = { 3 })

    Column(
        modifier = Modifier.fillMaxSize(),
        horizontalAlignment = Alignment.CenterHorizontally,
        verticalArrangement = Arrangement.Center
    ) {
        HorizontalPager(

            state = pagerState,
            modifier = Modifier.weight(1f)
        ) { page ->
            when (page) {
                0 -> TourPage(
                    imageRes = R.drawable.noteshop_logo,
                    title = stringResource(id = R.string.tour_page_1_title),
                    text = stringResource(id = R.string.tour_page_1_text)
                )
                1 -> TourPage(
                    imageRes = R.drawable.noteshop_logo,
                    title = stringResource(id = R.string.tour_page_2_title),
                    text = stringResource(id = R.string.tour_page_2_text)
                )
                2 -> TourPage(
                    imageRes = R.drawable.noteshop_logo,
                    title = stringResource(id = R.string.tour_page_3_title),
                    text = stringResource(id = R.string.tour_page_3_text)
                )
            }
        }

        HorizontalPagerIndicator(
            pagerState = pagerState,
            pageCount = 3,
            modifier = Modifier.padding(16.dp)
        )


        Button(
            onClick = onTourFinished,
            modifier = Modifier
                .fillMaxWidth()
                .padding(16.dp)
        ) {
            Text(text = if (pagerState.currentPage == 2) stringResource(id = R.string.tour_finish) else stringResource(id = R.string.tour_skip))
        }
    }
}

@Composable
fun TourPage(imageRes: Int, title: String, text: String) {
    Column(
        horizontalAlignment = Alignment.CenterHorizontally,
        verticalArrangement = Arrangement.Center,
        modifier = Modifier
            .fillMaxSize()
            .padding(16.dp)
    ) {
        Image(
            painter = painterResource(id = imageRes),
            contentDescription = null,
            modifier = Modifier.size(200.dp)
        )
        Spacer(modifier = Modifier.height(16.dp))
        Text(
            text = title,
            style = MaterialTheme.typography.headlineMedium,
            textAlign = TextAlign.Center
        )
        Spacer(modifier = Modifier.height(16.dp))
        Text(
            text = text,
            style = MaterialTheme.typography.bodyLarge,
            textAlign = TextAlign.Center
        )
    }
}

@Composable
fun HorizontalPagerIndicator(
    pagerState: androidx.compose.foundation.pager.PagerState,
    pageCount: Int,
    modifier: Modifier = Modifier,
    activeColor: androidx.compose.ui.graphics.Color = MaterialTheme.colorScheme.primary,
    inactiveColor: androidx.compose.ui.graphics.Color = MaterialTheme.colorScheme.onSurface.copy(alpha = 0.3f)
) {
    Row(
        modifier = modifier,
        horizontalArrangement = Arrangement.Center,
        verticalAlignment = Alignment.CenterVertically
    ) {
        for (i in 0 until pageCount) {
            val color = if (pagerState.currentPage == i) activeColor else inactiveColor
            Box(
                modifier = Modifier
                    .padding(2.dp)
                    .size(8.dp)
                    .background(color, MaterialTheme.shapes.small)
            )
        }
    }
}
