package de.lxtools.noteshop.ui

import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.AlertDialog
import androidx.compose.material3.RadioButton
import androidx.compose.material3.Text
import androidx.compose.material3.TextButton
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.unit.dp
import de.lxtools.noteshop.R

enum class LockMethod {
    BIOMETRIC,

    PASSWORD
}

@Composable
fun ChooseLockMethodDialog(
    onDismiss: () -> Unit,
    onConfirm: (LockMethod) -> Unit,
    canUseBiometrics: Boolean
) {
    var selectedMethod by remember { mutableStateOf(LockMethod.PASSWORD) }

    AlertDialog(
        onDismissRequest = onDismiss,
        title = { Text(text = stringResource(R.string.choose_lock_method)) },
        text = {
            Column {
                Row(
                    modifier = Modifier
                        .fillMaxWidth()
                        .clickable(enabled = canUseBiometrics) { if(canUseBiometrics) selectedMethod = LockMethod.BIOMETRIC }
                        .padding(vertical = 8.dp),
                    verticalAlignment = Alignment.CenterVertically
                ) {
                    RadioButton(
                        selected = selectedMethod == LockMethod.BIOMETRIC,
                        onClick = { if(canUseBiometrics) selectedMethod = LockMethod.BIOMETRIC },
                        enabled = canUseBiometrics
                    )
                    Text(text = stringResource(R.string.biometric_lock), modifier = Modifier.padding(start = 8.dp))
                }

                Row(
                    modifier = Modifier
                        .fillMaxWidth()
                        .clickable { selectedMethod = LockMethod.PASSWORD }
                        .padding(vertical = 8.dp),
                    verticalAlignment = Alignment.CenterVertically
                ) {
                    RadioButton(
                        selected = selectedMethod == LockMethod.PASSWORD,
                        onClick = { selectedMethod = LockMethod.PASSWORD }
                    )
                    Text(text = stringResource(R.string.password), modifier = Modifier.padding(start = 8.dp))
                }
            }
        },
        confirmButton = {
            TextButton(onClick = { onConfirm(selectedMethod) }) {
                Text(text = stringResource(R.string.ok))
            }
        },
        dismissButton = {
            TextButton(onClick = onDismiss) {
                Text(text = stringResource(R.string.cancel))
            }
        }
    )
}
