package de.lxtools.noteshop.data

import androidx.room.Dao
import androidx.room.Delete
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.Query
import androidx.room.Transaction
import androidx.room.Update
import kotlinx.coroutines.flow.Flow

@Dao
interface ShoppingListDao {

    // --- ShoppingList specific methods ---
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun insertList(list: ShoppingList): Long

    @Update
    suspend fun updateList(list: ShoppingList): Int

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun insertAllLists(lists: List<ShoppingList>)

    @Update
    suspend fun updateLists(lists: List<ShoppingList>)

    @Delete
    suspend fun deleteList(list: ShoppingList)

    @Query("SELECT COUNT(*) FROM shopping_lists")
    suspend fun getListsCount(): Int

    // --- ShoppingListItem specific methods ---
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun insertItem(item: ShoppingListItem)

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun insertAllItems(items: List<ShoppingListItem>)

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun insertItems(items: List<ShoppingListItem>)

    @Update
    suspend fun updateItem(item: ShoppingListItem)

    @Delete
    suspend fun deleteItem(item: ShoppingListItem)

    @Delete
    suspend fun deleteItems(items: List<ShoppingListItem>)

    @Update
    suspend fun updateItems(items: List<ShoppingListItem>)

    @Query("SELECT COUNT(*) FROM shopping_list_items WHERE list_id = :listId")
    suspend fun getItemsCount(listId: Int): Int

    // --- Methods for combined data ---
    @Query("SELECT * FROM shopping_lists WHERE name = :name")
    fun getShoppingListByName(name: String): Flow<ShoppingList?>

    @Transaction
    @Query("SELECT * FROM shopping_lists ORDER BY displayOrder ASC")
    fun getListsWithItems(): Flow<List<ShoppingListWithItems>>

    @Transaction
    @Query("SELECT * FROM shopping_lists WHERE id = :listId")
    fun getListWithItems(listId: Int): Flow<ShoppingListWithItems?>

    @Query("SELECT * FROM shopping_lists")
    fun getAllShoppingLists(): Flow<List<ShoppingList>>

    @Query("SELECT * FROM shopping_list_items")
    fun getAllShoppingListItems(): Flow<List<ShoppingListItem>>
}