package de.lxtools.noteshop.data

import androidx.room.Entity
import androidx.room.PrimaryKey
import kotlinx.serialization.Serializable

@Serializable
@Entity(tableName = "shopping_lists")
data class ShoppingList(
    @PrimaryKey(autoGenerate = true)
    val id: Int = 0,
    val name: String,
    val displayOrder: Int = 0,
    val protectionHash: String = "",
    val protectionType: Int = 0,
    val lockMethod: Int = 0,
    val encryptedItems: String? = null
)