package de.lxtools.noteshop.data

import android.content.Context
import android.content.SharedPreferences
import androidx.core.content.edit
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow

class SettingsRepository(context: Context) {

    private val prefs = context.getSharedPreferences("noteshop_settings", Context.MODE_PRIVATE)

    private val _databaseUri = MutableStateFlow(prefs.getString(KEY_DATABASE_URI, null))
    val databaseUri: StateFlow<String?> = _databaseUri

    private val listener = SharedPreferences.OnSharedPreferenceChangeListener { _, key ->
        if (key == KEY_DATABASE_URI) {
            _databaseUri.value = prefs.getString(KEY_DATABASE_URI, null)
        }
    }

    init {
        prefs.registerOnSharedPreferenceChangeListener(listener)
    }

    fun setDatabaseUri(uri: String?) {
        prefs.edit {
            putString(KEY_DATABASE_URI, uri)
        }
    }

    companion object {
        private const val KEY_DATABASE_URI = "database_uri"
    }
}

