package de.lxtools.noteshop.data

import androidx.room.Entity
import androidx.room.PrimaryKey
import kotlinx.serialization.Serializable

@Serializable
@Entity(tableName = "notes")
data class Note(
    @PrimaryKey(autoGenerate = true)
    val id: Int = 0,
    val title: String,
    val content: String,
    val displayOrder: Int = 0,
    val protectionHash: String = "",
    val protectionType: Int = 0,
    val lockMethod: Int = 0
)