package de.lxtools.noteshop.data

import android.content.Context
import android.net.Uri
import de.lxtools.noteshop.api.WebAppClient

interface AppContainer {
    val noteshopRepository: NoteshopRepository
}

class AppDataContainer(private val context: Context, private val dbUri: Uri) : AppContainer {
    private val webAppClient: WebAppClient by lazy {
        WebAppClient()
    }


    override val noteshopRepository: NoteshopRepository by lazy {

        OfflineNoteshopRepository(
            noteDao = AppDatabase.getDatabase(context, dbUri).noteDao(),
            shoppingListDao = AppDatabase.getDatabase(context, dbUri).shoppingListDao(),
            recipeDao = AppDatabase.getDatabase(context, dbUri).recipeDao(),
            webAppClient = webAppClient,
            context = context
        )
    }
}