package de.lxtools.noteshop

import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import androidx.lifecycle.viewmodel.CreationExtras
import de.lxtools.noteshop.data.AppContainer
import de.lxtools.noteshop.ui.notes.NotesViewModel
import de.lxtools.noteshop.ui.recipes.RecipesViewModel
import de.lxtools.noteshop.ui.shopping.ShoppingListsViewModel
import de.lxtools.noteshop.ui.webapp.WebAppIntegrationViewModel

object AppViewModelProvider {
    class Factory(private val container: AppContainer) : ViewModelProvider.Factory {
        @Suppress("UNCHECKED_CAST")
        override fun <T : ViewModel> create(modelClass: Class<T>, extras: CreationExtras): T {
            val application = extras[ViewModelProvider.AndroidViewModelFactory.APPLICATION_KEY] as NoteshopApplication
            return when {
                modelClass.isAssignableFrom(NotesViewModel::class.java) -> {
                    NotesViewModel(container.noteshopRepository) as T
                }
                modelClass.isAssignableFrom(ShoppingListsViewModel::class.java) -> {
                    ShoppingListsViewModel(container.noteshopRepository, application) as T
                }
                modelClass.isAssignableFrom(RecipesViewModel::class.java) -> {
                    RecipesViewModel(container.noteshopRepository) as T
                }
                modelClass.isAssignableFrom(WebAppIntegrationViewModel::class.java) -> {
                    WebAppIntegrationViewModel(container.noteshopRepository, application) as T
                }
                else -> throw IllegalArgumentException("Unknown ViewModel class: " + modelClass.name)
            }
        }
    }
}

fun CreationExtras.noteshopApplication(): NoteshopApplication =
    this[ViewModelProvider.AndroidViewModelFactory.APPLICATION_KEY] as NoteshopApplication