# Noteshop

[![F-Droid](https://img.shields.io/f-droid/v/de.lxtools.noteshop.svg)](https://f-droid.org/packages/de.lxtools.noteshop/) <!-- Replace with your actual F-Droid link when available -->
[![License: GPL v3](https://img.shields.io/badge/License-GPLv3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0)

Noteshop is a versatile and privacy-focused application for managing your notes, shopping lists, and recipes all in one place. It is designed to be simple, efficient, and fully under your control.

## Screenshots

| Shopping List | Recipes | Notes Screen |
|---|---|---|
| ![Screenshot of Shopping List](fastlane/metadata/android/en-US/images/phoneScreenshots/Shoppinscreen.png) | ![Screenshot of Recipes](fastlane/metadata/android/en-US/images/phoneScreenshots/Recipesscreen.png) | ![Screenshot of Notes Screen](fastlane/metadata/android/en-US/images/phoneScreenshots/Notesscreen.png) |

| Menu Screen | Settings | Wepp-App |
|---|---|---|
| ![Screenshot of Menu Screen](fastlane/metadata/android/en-US/images/phoneScreenshots/Menuscreen.png) | ![Screenshot of Settings](fastlane/metadata/android/en-US/images/phoneScreenshots/Settingsscreen.png) | ![Screenshot of Web-App](fastlane/metadata/android/en-US/images/phoneScreenshots/WebAppscreen.png) |


## Features

*   **📝 Notes:** Create and manage simple or detailed notes.
*   **🛒 Shopping Lists:** An intelligent shopping list system with features like item completion, reordering, and a standard items catalog.
*   **🍲 Recipes:** Store and organize your favorite recipes.
*   **🔒 Privacy & Security:** Your data is yours. Noteshop offers robust security features and the ability to lock individual items with a biometric, password, PIN, or pattern.
*   **🔄 Synchronization:** Keep your data in sync across devices. Noteshop supports two methods:
    *   **Web App Integration:** Synchronize with a self-hosted web application.
    *   **Local File Sync:** Use tools like Syncthing to sync your data via a designated folder on your device.
*   **🎨 Themes:** Customize the look and feel of the app with different color themes.
*   **🌐 Open Source:** Noteshop is 100% free and open-source. No ads, no tracking.

## Download

*   [<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png" alt="Get it on F-Droid" height="80">](https://f-droid.org/packages/de.lxtools.noteshop/) <!-- Replace with your actual F-Droid link -->

## Permissions                                                                                                                                           
                                                                                                                                                          
The app requests the following permissions to provide its full functionality:                                                                            
                                                                                                                                                          
*   **INTERNET**: Required for database synchronization (e.g., with Syncthing-Fork for a future PC version) and for the web app to fetch list entries    
when used (optional).                                                                                                                                    
*   **USE_BIOMETRIC** / **USE_FINGERPRINT**: Used for biometric authentication (fingerprint, PIN, password etc.) to lock the app itself and to           
individually secure lists, recipes, and notes.                                                                                                           
*   **de.lxtools.noteshop.DYNAMIC_RECEIVER_NOT_EXPORTED_PERMISSION**: This custom permission is likely related to the app's ability to export and import 
all recipes, notes, and shopping lists separately in JSON format, and also to export individual lists, notes, and recipes as TXT files. This ensures     
secure internal communication within the app related to these export/import functionalities. 

## Building from Source

1.  Clone the repository:
    ```sh
    git clone https://git.ilunix.de/punix/noteshop.git && cd noteshop
    ```
2.  Build the app using Gradle:
    ```sh
    ./gradlew assembleRelease
    ```
    The resulting APK will be located in `app/build/outputs/apk/release/`.

## License

This project is licensed under the GNU General Public License v3.0. See the [LICENSE](https://www.gnu.org/licenses/gpl-3.0.html) file for details.

## Privacy

Please see our [Privacy Policy](PRIVACY.md) for details on how the app handles your data.
