# Nextcloud Cookbook Android client

[![ci](https://github.com/lneugebauer/nextcloud-cookbook/actions/workflows/ci.yml/badge.svg)](https://github.com/lneugebauer/nextcloud-cookbook/actions/workflows/ci.yml)
[![F-Droid release](https://img.shields.io/f-droid/v/de.lukasneugebauer.nextcloudcookbook.svg?logo=F-Droid)](https://f-droid.org/packages/de.lukasneugebauer.nextcloudcookbook/)
[![GitHub release](https://img.shields.io/github/release/lneugebauer/nextcloud-cookbook.svg?logo=github)](https://github.com/lneugebauer/nextcloud-cookbook/releases)
![GitHub all downloads](https://img.shields.io/github/downloads/lneugebauer/nextcloud-cookbook/total?logo=github)
[![GitHub issues](https://img.shields.io/github/issues/lneugebauer/nextcloud-cookbook.svg?logo=github)](https://github.com/lneugebauer/nextcloud-cookbook/issues)
[![license](https://img.shields.io/badge/license-MIT-blue.svg)](https://github.com/lneugebauer/nextcloud-cookbook/blob/main/LICENSE)
[![ktlint](https://img.shields.io/badge/code%20style-%E2%9D%A4-FF4081.svg)](https://ktlint.github.io/)
[![Translation status](https://hosted.weblate.org/widget/nextcloud-cookbook/svg-badge.svg)](https://hosted.weblate.org/engage/nextcloud-cookbook/)
[![Liberapay patrons](https://img.shields.io/liberapay/patrons/lneugebauer.svg?logo=liberapay)](https://liberapay.com/lneugebauer/)

An Android client for [Nextcloud Cookbook app](https://github.com/nextcloud/cookbook).

## Download

[<img src="https://play.google.com/intl/en_us/badges/images/generic/en_badge_web_generic.png"
    alt="Get it on Play Store"
    height="80">](https://play.google.com/store/apps/details?id=de.lukasneugebauer.nextcloudcookbook)
[<img src="/docs/assets/images/get_it_on_github.png"
    alt="Get it on GitHub"
    height="80">](https://github.com/lneugebauer/nextcloud-cookbook/releases)
[<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png"
    alt="Get it on F-Droid"
    height="80">](https://f-droid.org/packages/de.lukasneugebauer.nextcloudcookbook/)

### Obtainium

To install through [Obtainium](https://github.com/ImranR98/Obtainium/tree/main?tab=readme-ov-file#installation), simply go to Add App and paste the URL of this repository as the source URL: `https://github.com/lneugebauer/nextcloud-cookbook`.

## Screenshots

<table>
    <tr>
        <td>Phone</td>
        <td><img src="fastlane/metadata/android/en-US/images/phoneScreenshots/1.png" alt="Phone screenshot 1"></td>
        <td><img src="fastlane/metadata/android/en-US/images/phoneScreenshots/2.png" alt="Phone screenshot 2"></td>
        <td><img src="fastlane/metadata/android/en-US/images/phoneScreenshots/3.png" alt="Phone screenshot 3"></td>
        <td><img src="fastlane/metadata/android/en-US/images/phoneScreenshots/4.png" alt="Phone screenshot 4"></td>
    </tr>
    <tr>
        <td>Tablet</td>
        <td><img src="fastlane/metadata/android/en-US/images/tenInchScreenshots/1.png" alt="Tablet screenshot 1"></td>
        <td><img src="fastlane/metadata/android/en-US/images/tenInchScreenshots/2.png" alt="Tablet screenshot 2"></td>
        <td><img src="fastlane/metadata/android/en-US/images/tenInchScreenshots/3.png" alt="Tablet screenshot 3"></td>
        <td><img src="fastlane/metadata/android/en-US/images/tenInchScreenshots/4.png" alt="Tablet screenshot 4"></td>
    </tr>
</table>

*Photo by [Eaters Collective](https://unsplash.com/@eaterscollective?utm_content=creditCopyText&utm_medium=referral&utm_source=unsplash) on [Unsplash](https://unsplash.com/photos/pesto-pasta-with-sliced-tomatoes-served-on-white-ceramic-plate-12eHC6FxPyg?utm_content=creditCopyText&utm_medium=referral&utm_source=unsplash)*  
*Photo by [Ella Olsson](https://unsplash.com/@ellaolsson?utm_content=creditCopyText&utm_medium=referral&utm_source=unsplash) on [Unsplash](https://unsplash.com/photos/assorted-fruits-and-vegetable-on-brown-wooden-chopping-board-2IxTgsgFi-s?utm_content=creditCopyText&utm_medium=referral&utm_source=unsplash)*  
*Photo by [Marcin Andrzejewski](https://unsplash.com/@marcinandrzejewskipl?utm_content=creditCopyText&utm_medium=referral&utm_source=unsplash) on [Unsplash](https://unsplash.com/photos/fried-chicken-on-white-ceramic-plate-LTlniUw9xWE?utm_content=creditCopyText&utm_medium=referral&utm_source=unsplash)*  
*Photo by [Aurélien Lemasson-Théobald](https://unsplash.com/@aurel__lens?utm_content=creditCopyText&utm_medium=referral&utm_source=unsplash) on [Unsplash](https://unsplash.com/photos/round-cooked-pizza-x00CzBt4Dfk?utm_content=creditCopyText&utm_medium=referral&utm_source=unsplash)*  

## Features :rocket:

- List all recipes
- List all recipes by category
- Create recipe
- View recipe
- Edit recipe
- Stay awake on recipe screen
- Settings
- Import recipe via url

## Planned features :checkered_flag:

- Offline usage
- Single Sign On through Nextcloud Files app
- Login via QR-Code

## Requirements :link:

* [Nextcloud](https://nextcloud.com/) instance running
* [Nextcloud Cookbook](https://github.com/nextcloud/cookbook) app enabled

## Build the app :hammer_and_wrench:

1. Open project in Android Studio
2. Run the app

## Contributing :office_worker:

- [Bugfix](https://github.com/lneugebauer/nextcloud-cookbook/blob/main/docs/contributing.md#bugfix)
- [Feature](https://github.com/lneugebauer/nextcloud-cookbook/blob/main/docs/contributing.md#featuresimprovements)
- [Translations](https://github.com/lneugebauer/nextcloud-cookbook/blob/main/docs/contributing.md#translations)

### Translations :earth_africa:

[![Translation status](https://hosted.weblate.org/widget/nextcloud-cookbook/287x66-grey.png)](https://hosted.weblate.org/engage/nextcloud-cookbook/)

## License

[MIT License](https://github.com/lneugebauer/nextcloud-cookbook/blob/main/LICENSE)
