package de.luhmer.owncloudnewsreader.database.model;

import java.util.List;

import de.greenrobot.dao.DaoException;

// THIS CODE IS GENERATED BY greenDAO, EDIT ONLY INSIDE THE "KEEP"-SECTIONS

// KEEP INCLUDES - put your custom includes here
// KEEP INCLUDES END
/**
 * Entity mapped to table "FEED".
 */
public class Feed {

    private long id;
    private Long folderId;
    /** Not-null value. */
    private String feedTitle;
    private String faviconUrl;
    private String link;
    private String avgColour;
    private String notificationChannel;
    private Long openIn;

    /** Used to resolve relations */
    private transient DaoSession daoSession;

    /** Used for active entity operations. */
    private transient FeedDao myDao;

    private Folder folder;
    private Long folder__resolvedKey;

    private List<RssItem> rssItemList;

    // KEEP FIELDS - put your custom fields here
    // KEEP FIELDS END

    public Feed() {
    }

    public Feed(long id) {
        this.id = id;
    }

    public Feed(long id, Long folderId, String feedTitle, String faviconUrl, String link, String avgColour, String notificationChannel, Long openIn) {
        this.id = id;
        this.folderId = folderId;
        this.feedTitle = feedTitle;
        this.faviconUrl = faviconUrl;
        this.link = link;
        this.avgColour = avgColour;
        this.notificationChannel = notificationChannel;
        this.openIn = openIn;
    }

    /** called by internal mechanisms, do not call yourself. */
    public void __setDaoSession(DaoSession daoSession) {
        this.daoSession = daoSession;
        myDao = daoSession != null ? daoSession.getFeedDao() : null;
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Long getFolderId() {
        return folderId;
    }

    public void setFolderId(Long folderId) {
        this.folderId = folderId;
    }

    /** Not-null value. */
    public String getFeedTitle() {
        return feedTitle;
    }

    /** Not-null value; ensure this value is available before it is saved to the database. */
    public void setFeedTitle(String feedTitle) {
        this.feedTitle = feedTitle;
    }

    public String getFaviconUrl() {
        return faviconUrl;
    }

    public void setFaviconUrl(String faviconUrl) {
        this.faviconUrl = faviconUrl;
    }

    public String getLink() {
        return link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getAvgColour() {
        return avgColour;
    }

    public void setAvgColour(String avgColour) {
        this.avgColour = avgColour;
    }

    public String getNotificationChannel() {
        return notificationChannel;
    }

    public void setNotificationChannel(String notificationChannel) {
        this.notificationChannel = notificationChannel;
    }

    public Long getOpenIn() {
        return openIn;
    }

    public void setOpenIn(Long openIn) {
        this.openIn = openIn;
    }

    /**
     * To-one relationship, resolved on first access.
     */
    public Folder getFolder() {
        Long __key = this.folderId;
        if (folder__resolvedKey == null || !folder__resolvedKey.equals(__key)) {
            if (daoSession == null) {
                throw new DaoException("Entity is detached from DAO context");
            }
            FolderDao targetDao = daoSession.getFolderDao();
            Folder folderNew = targetDao.load(__key);
            synchronized (this) {
                folder = folderNew;
            	folder__resolvedKey = __key;
            }
        }
        return folder;
    }

    public void setFolder(Folder folder) {
        synchronized (this) {
            this.folder = folder;
            folderId = folder == null ? null : folder.getId();
            folder__resolvedKey = folderId;
        }
    }

    /** To-many relationship, resolved on first access (and after reset). Changes to to-many relations are not persisted, make changes to the target entity. */
    public List<RssItem> getRssItemList() {
        if (rssItemList == null) {
            if (daoSession == null) {
                throw new DaoException("Entity is detached from DAO context");
            }
            RssItemDao targetDao = daoSession.getRssItemDao();
            List<RssItem> rssItemListNew = targetDao._queryFeed_RssItemList(id);
            synchronized (this) {
                if(rssItemList == null) {
                    rssItemList = rssItemListNew;
                }
            }
        }
        return rssItemList;
    }

    /** Resets a to-many relationship, making the next get call to query for a fresh result. */
    public synchronized void resetRssItemList() {
        rssItemList = null;
    }

    /** Convenient call for {@link AbstractDao#delete(Object)}. Entity must attached to an entity context. */
    public void delete() {
        if (myDao == null) {
            throw new DaoException("Entity is detached from DAO context");
        }    
        myDao.delete(this);
    }

    /** Convenient call for {@link AbstractDao#update(Object)}. Entity must attached to an entity context. */
    public void update() {
        if (myDao == null) {
            throw new DaoException("Entity is detached from DAO context");
        }    
        myDao.update(this);
    }

    /** Convenient call for {@link AbstractDao#refresh(Object)}. Entity must attached to an entity context. */
    public void refresh() {
        if (myDao == null) {
            throw new DaoException("Entity is detached from DAO context");
        }    
        myDao.refresh(this);
    }

    // KEEP METHODS - put your custom methods here
    // KEEP METHODS END

}
