package de.luhmer.owncloudnewsreader.database.model;

import android.database.sqlite.SQLiteDatabase;

import java.util.Map;

import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.AbstractDaoSession;
import de.greenrobot.dao.identityscope.IdentityScopeType;
import de.greenrobot.dao.internal.DaoConfig;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.

/**
 * {@inheritDoc}
 * 
 * @see de.greenrobot.dao.AbstractDaoSession
 */
public class DaoSession extends AbstractDaoSession {

    private final DaoConfig folderDaoConfig;
    private final DaoConfig feedDaoConfig;
    private final DaoConfig rssItemDaoConfig;
    private final DaoConfig currentRssItemViewDaoConfig;

    private final FolderDao folderDao;
    private final FeedDao feedDao;
    private final RssItemDao rssItemDao;
    private final CurrentRssItemViewDao currentRssItemViewDao;

    public DaoSession(SQLiteDatabase db, IdentityScopeType type, Map<Class<? extends AbstractDao<?, ?>>, DaoConfig>
            daoConfigMap) {
        super(db);

        folderDaoConfig = daoConfigMap.get(FolderDao.class).clone();
        folderDaoConfig.initIdentityScope(type);

        feedDaoConfig = daoConfigMap.get(FeedDao.class).clone();
        feedDaoConfig.initIdentityScope(type);

        rssItemDaoConfig = daoConfigMap.get(RssItemDao.class).clone();
        rssItemDaoConfig.initIdentityScope(type);

        currentRssItemViewDaoConfig = daoConfigMap.get(CurrentRssItemViewDao.class).clone();
        currentRssItemViewDaoConfig.initIdentityScope(type);

        folderDao = new FolderDao(folderDaoConfig, this);
        feedDao = new FeedDao(feedDaoConfig, this);
        rssItemDao = new RssItemDao(rssItemDaoConfig, this);
        currentRssItemViewDao = new CurrentRssItemViewDao(currentRssItemViewDaoConfig, this);

        registerDao(Folder.class, folderDao);
        registerDao(Feed.class, feedDao);
        registerDao(RssItem.class, rssItemDao);
        registerDao(CurrentRssItemView.class, currentRssItemViewDao);
    }
    
    public void clear() {
        folderDaoConfig.getIdentityScope().clear();
        feedDaoConfig.getIdentityScope().clear();
        rssItemDaoConfig.getIdentityScope().clear();
        currentRssItemViewDaoConfig.getIdentityScope().clear();
    }

    public FolderDao getFolderDao() {
        return folderDao;
    }

    public FeedDao getFeedDao() {
        return feedDao;
    }

    public RssItemDao getRssItemDao() {
        return rssItemDao;
    }

    public CurrentRssItemViewDao getCurrentRssItemViewDao() {
        return currentRssItemViewDao;
    }

}
