package de.luhmer.owncloudnewsreader.database.model;

import de.greenrobot.dao.DaoException;
import de.luhmer.owncloudnewsreader.adapter.HasId;

// THIS CODE IS GENERATED BY greenDAO, EDIT ONLY INSIDE THE "KEEP"-SECTIONS

// KEEP INCLUDES - put your custom includes here
// KEEP INCLUDES END
/**
 * Entity mapped to table "RSS_ITEM".
 */
public class RssItem implements HasId<Long> {

    private long id;
    private long feedId;
    private String link;
    private String title;
    private String body;
    private Boolean read;
    private Boolean starred;
    /** Not-null value. */
    private String author;
    /** Not-null value. */
    private String guid;
    /** Not-null value. */
    private String guidHash;
    /** Not-null value. */
    private String fingerprint;
    private Boolean read_temp;
    private Boolean starred_temp;
    private java.util.Date lastModified;
    private java.util.Date pubDate;
    private String enclosureLink;
    private String enclosureMime;
    private String mediaThumbnail;
    private String mediaDescription;
    private Boolean rtl;

    /** Used to resolve relations */
    private transient DaoSession daoSession;

    /** Used for active entity operations. */
    private transient RssItemDao myDao;

    private Feed feed;
    private Long feed__resolvedKey;


    // KEEP FIELDS - put your custom fields here
    // KEEP FIELDS END

    public RssItem() {
    }

    public RssItem(long id) {
        this.id = id;
    }

    public RssItem(long id, long feedId, String link, String title, String body, Boolean read, Boolean starred, String author, String guid, String guidHash, String fingerprint, Boolean read_temp, Boolean starred_temp, java.util.Date lastModified, java.util.Date pubDate, String enclosureLink, String enclosureMime, String mediaThumbnail, String mediaDescription, Boolean rtl) {
        this.id = id;
        this.feedId = feedId;
        this.link = link;
        this.title = title;
        this.body = body;
        this.read = read;
        this.starred = starred;
        this.author = author;
        this.guid = guid;
        this.guidHash = guidHash;
        this.fingerprint = fingerprint;
        this.read_temp = read_temp;
        this.starred_temp = starred_temp;
        this.lastModified = lastModified;
        this.pubDate = pubDate;
        this.enclosureLink = enclosureLink;
        this.enclosureMime = enclosureMime;
        this.mediaThumbnail = mediaThumbnail;
        this.mediaDescription = mediaDescription;
        this.rtl = rtl;
    }

    /** called by internal mechanisms, do not call yourself. */
    public void __setDaoSession(DaoSession daoSession) {
        this.daoSession = daoSession;
        myDao = daoSession != null ? daoSession.getRssItemDao() : null;
    }

    public Long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getFeedId() {
        return feedId;
    }

    public void setFeedId(long feedId) {
        this.feedId = feedId;
    }

    public String getLink() {
        return link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Boolean getRead() {
        return read;
    }

    public void setRead(Boolean read) {
        this.read = read;
    }

    public Boolean getStarred() {
        return starred;
    }

    public void setStarred(Boolean starred) {
        this.starred = starred;
    }

    /** Not-null value. */
    public String getAuthor() {
        return author;
    }

    /** Not-null value; ensure this value is available before it is saved to the database. */
    public void setAuthor(String author) {
        this.author = author;
    }

    /** Not-null value. */
    public String getGuid() {
        return guid;
    }

    /** Not-null value; ensure this value is available before it is saved to the database. */
    public void setGuid(String guid) {
        this.guid = guid;
    }

    /** Not-null value. */
    public String getGuidHash() {
        return guidHash;
    }

    /** Not-null value; ensure this value is available before it is saved to the database. */
    public void setGuidHash(String guidHash) {
        this.guidHash = guidHash;
    }

    /** Not-null value. */
    public String getFingerprint() {
        return fingerprint;
    }

    /** Not-null value; ensure this value is available before it is saved to the database. */
    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public Boolean getRead_temp() {
        return read_temp;
    }

    public void setRead_temp(Boolean read_temp) {
        this.read_temp = read_temp;
    }

    public Boolean getStarred_temp() {
        return starred_temp;
    }

    public void setStarred_temp(Boolean starred_temp) {
        this.starred_temp = starred_temp;
    }

    public java.util.Date getLastModified() {
        return lastModified;
    }

    public void setLastModified(java.util.Date lastModified) {
        this.lastModified = lastModified;
    }

    public java.util.Date getPubDate() {
        return pubDate;
    }

    public void setPubDate(java.util.Date pubDate) {
        this.pubDate = pubDate;
    }

    public String getEnclosureLink() {
        return enclosureLink;
    }

    public void setEnclosureLink(String enclosureLink) {
        this.enclosureLink = enclosureLink;
    }

    public String getEnclosureMime() {
        return enclosureMime;
    }

    public void setEnclosureMime(String enclosureMime) {
        this.enclosureMime = enclosureMime;
    }

    public String getMediaThumbnail() {
        return mediaThumbnail;
    }

    public void setMediaThumbnail(String mediaThumbnail) {
        this.mediaThumbnail = mediaThumbnail;
    }

    public String getMediaDescription() {
        return mediaDescription;
    }

    public void setMediaDescription(String mediaDescription) {
        this.mediaDescription = mediaDescription;
    }

    public Boolean getRtl() {
        return rtl;
    }

    public void setRtl(Boolean rtl) {
        this.rtl = rtl;
    }

    /** To-one relationship, resolved on first access. */
    public Feed getFeed() {
        long __key = this.feedId;
        if (feed__resolvedKey == null || !feed__resolvedKey.equals(__key)) {
            if (daoSession == null) {
                throw new DaoException("Entity is detached from DAO context");
            }
            FeedDao targetDao = daoSession.getFeedDao();
            Feed feedNew = targetDao.load(__key);
            synchronized (this) {
                feed = feedNew;
            	feed__resolvedKey = __key;
            }
        }
        return feed;
    }

    public void setFeed(Feed feed) {
        if (feed == null) {
            throw new DaoException("To-one property 'feedId' has not-null constraint; cannot set to-one to null");
        }
        synchronized (this) {
            this.feed = feed;
            feedId = feed.getId();
            feed__resolvedKey = feedId;
        }
    }

    /** Convenient call for {@link AbstractDao#delete(Object)}. Entity must attached to an entity context. */
    public void delete() {
        if (myDao == null) {
            throw new DaoException("Entity is detached from DAO context");
        }    
        myDao.delete(this);
    }

    /** Convenient call for {@link AbstractDao#update(Object)}. Entity must attached to an entity context. */
    public void update() {
        if (myDao == null) {
            throw new DaoException("Entity is detached from DAO context");
        }    
        myDao.update(this);
    }

    /** Convenient call for {@link AbstractDao#refresh(Object)}. Entity must attached to an entity context. */
    public void refresh() {
        if (myDao == null) {
            throw new DaoException("Entity is detached from DAO context");
        }    
        myDao.refresh(this);
    }

    // KEEP METHODS - put your custom methods here
    // KEEP METHODS END

}
