/*
 * Copyright (C) 2018-20 Andreas Kromke, andreas.kromke@gmail.com
 *
 * This program is free software; you can redistribute it or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package de.kromke.andreas.safmediascanner;

/*
 * minimalistic preferences
 */

import android.content.SharedPreferences;
import android.graphics.Insets;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.WindowInsets;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.preference.Preference;
import androidx.preference.PreferenceFragmentCompat;
import androidx.preference.PreferenceManager;

public class MyPreferenceActivity extends AppCompatActivity
{
    static public class MySettingsFragment extends PreferenceFragmentCompat
    {
        @Override
        public void onCreatePreferences(Bundle savedInstanceState, String rootKey)
        {
            setPreferencesFromResource(R.xml.preferences, rootKey);

            //
            // special handling for non-editable information about shared db path
            //

            Preference sharedDbPathPref = findPreference("prefSharedDbDirectoryUri");
            if (sharedDbPathPref != null)
            {
                final String key = sharedDbPathPref.getKey();
                PreferenceManager manager = getPreferenceManager();
                SharedPreferences sharedPrefs = manager.getSharedPreferences();
                String value = (sharedPrefs != null) ? sharedPrefs.getString(key, "(none)") : "(none)";
                sharedDbPathPref.setSummary(value);

                /* edit text preferences have their value as text
                if (sharedDbPathPref instanceof EditTextPreference)
                {
                    //sharedDbPathPref.setSummary(sharedDbPathPref.getText());
                }
                 */
            }
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);

        // Android 16: Prevent GUI elements from being obscured behind status and navigation bars
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.VANILLA_ICE_CREAM)
        {
            findViewById(android.R.id.content).setOnApplyWindowInsetsListener(new View.OnApplyWindowInsetsListener()
            {
                @NonNull
                @Override
                public WindowInsets onApplyWindowInsets(@NonNull View v, @NonNull WindowInsets insets)
                {
                    // get top padding from status bar and bottom padding from navigation bar
                    Insets barInsets = insets.getInsets(WindowInsets.Type.statusBars() | WindowInsets.Type.navigationBars());
                    v.setPadding(0, barInsets.top, 0, barInsets.bottom);
                    return insets;
                }
            });
        }

        getSupportFragmentManager()
                .beginTransaction()
                .replace(android.R.id.content, new MySettingsFragment())
                .commit();
    }
}
